local M = {}
M.type = "auxiliary"
M.relevantDevice = nil

local htmlTexture = require("htmlTexture")

local gaugesScreenName = nil
local htmlPath = nil

local updateTimer = 0
local updateGraphTimer = 0

local updateFPS = 30
local invFPS = 1 / updateFPS
--from sbr gauge lua
local avgConsumptionSmoother = newExponentialSmoothing(1000)
local avgPowerSmoother = newExponentialSmoothing(1000)
local currentConsumptionSmoother = newExponentialSmoothing(50)
local currentPowerSmoother = newExponentialSmoothing(30)
local lastEnergyAvailable = 0
local avgConsumptionPer100km = 0
local avgPower = 0
local range = 0

local batteriesUsed = {}

local function updateGFX(dt)
  updateTimer = updateTimer + dt
  updateGraphTimer = updateGraphTimer + dt

  if updateTimer > invFPS then
  
  --from sbr gauge lua
    local wheelSpeed = electrics.values["wheelspeed"] * 3.6
    local isMoving = wheelSpeed > 1

    local energyLeft = 0
    for k, _ in pairs(batteriesUsed) do
      local storage = energyStorage.getStorage(k)
      energyLeft = energyLeft + storage.storedEnergy
    end

    local diff = lastEnergyAvailable - energyLeft
    local currentPower = currentPowerSmoother:get(diff / updateTimer) --J/s aka W
    avgPower = avgPowerSmoother:get(isMoving and currentPower or avgPower)

    lastEnergyAvailable = energyLeft

    local timeToGo100km = isMoving and (100 / wheelSpeed) or 0
    local currentConsumptionPer100km = currentPower * timeToGo100km

    currentConsumptionPer100km = currentConsumptionSmoother:get(currentConsumptionPer100km)
    avgConsumptionPer100km = avgConsumptionSmoother:get(isMoving and currentConsumptionPer100km or avgConsumptionPer100km)

    if updateGraphTimer > 5 then
      range = avgConsumptionPer100km > 0 and (energyLeft * 0.0278 / avgConsumptionPer100km) or 0
      updateGraphTimer = 0
	end
    local data = {}
	
    data.tillempty = range
    data.parkingbrake = electrics.values["parkingbrake"]
	data.odometer =  electrics.values["focusOdometer"]
	data.enginerunning = electrics.values["engineRunning"]
	
    data.bottomscreenunit = settings.getValue("uiUnitLength") or "metric"
	
    --dump(data)
    htmlTexture.call(gaugesScreenName, "update", data)
    updateTimer = 0
  end
end

local function init(jbeamData)
	gaugesScreenName = jbeamData.materialName
	htmlPath = jbeamData.htmlPath
	local width = jbeamData.textureWidth or 512
	local height = jbeamData.textureHeight or 256

    htmlTexture.create(gaugesScreenName, htmlPath, width, height, updateFPS, "automatic")
    htmlTexture.call(gaugesScreenName, "init")

  batteriesUsed = {}
  local motors = powertrain.getDevicesByType("electricMotor")
  for _, v in pairs(motors) do
    for _, j in pairs(v.registeredEnergyStorages) do
      batteriesUsed[j] = true
    end
  end

  local motor = powertrain.getDevicesByType("combustionEngine")
  for _, v in pairs(motor) do
    for _, j in pairs(v.registeredEnergyStorages) do
      batteriesUsed[j] = true
    end
  end

  lastEnergyAvailable = 0

  for k, _ in pairs(batteriesUsed) do
    local storage = energyStorage.getStorage(k)
    lastEnergyAvailable = lastEnergyAvailable + storage.storedEnergy
  end
  avgConsumptionSmoother:set(20000)
  currentConsumptionSmoother:set(0)
  currentPowerSmoother:set(0)
end

M.init = init
M.updateGFX = updateGFX

return M
