--This LUA Script has been produced by Phaien.
--Using this code for your own mod is allowed as long as Credits to my name, "Phaien", are given.


local M = {}
M.type = "auxiliary"

local max = math.max

local lightSteps = nil
local minRPM = 0
local maxRPM = 0
local inputElectricsName = nil
local keepLowerLEDsOn = true
local stallWarningEngine = nil
local hasStallWarning = true

local function updateGFX(dt)
  local rpm = electrics.values[inputElectricsName]

  -- Wenn RPM den maxRPM überschreitet, setze alle LEDs auf 1
  if rpm >= maxRPM then
    for _, v in ipairs(lightSteps) do
      electrics.values[v.electricsName] = 1  -- Alle LEDs aktivieren, wenn RPM > maxRPM
    end
  else
    -- LEDs aktivieren, die für den aktuellen RPM-Wert passend sind
    for _, v in ipairs(lightSteps) do
      if rpm >= v.startRPM then
        electrics.values[v.electricsName] = 1  -- Schalte alle LEDs ein, deren Startwert <= aktueller RPM ist
      else
        electrics.values[v.electricsName] = 0  -- Schalte LEDs aus, die nicht mehr relevant sind
      end
    end
  end
end

local function init(jbeamData)
  lightSteps = {}

  maxRPM = 11000
  local rpmRange = jbeamData.rpmRange or 3000
  hasStallWarning = false

  if jbeamData.engineName and jbeamData.maxEngineRPMOffset then
    local engine = powertrain.getDevice(jbeamData.engineName)
    if engine then
      maxRPM = engine.maxRPM - jbeamData.maxEngineRPMOffset
      stallWarningEngine = engine
      hasStallWarning = jbeamData.hasStallWarning or false
    end
  end

  maxRPM = jbeamData.maxRPM or maxRPM
  minRPM = maxRPM - rpmRange
  minRPM = jbeamData.minRPM or minRPM

  inputElectricsName = jbeamData.inputElectricsName or "rpm"
  keepLowerLEDsOn = jbeamData.keepLEDsActive == nil and true or jbeamData.keepLEDsActive

  local steps = jbeamData.outputElectrics or {}
  local stepCount = #steps
  local rpmStepRange = maxRPM - minRPM
  local rpmStep = rpmStepRange / stepCount
  for i = 1, stepCount do
    local step = steps[i]
    local stepData = {startRPM = minRPM + rpmStep * (i - 1), endRPM = minRPM + rpmStep * i, electricsName = step}
    table.insert(lightSteps, stepData)
  end

  -- Entferne alle Logik für das Blinken
  -- Keine weiteren Variablen oder Schritte für das Blinken von LEDs
end

M.init = init
M.updateGFX = updateGFX

return M
