-- Brake bias controller by Zeit and LucasBE
-- Do not reuse or modify without permission

local M = {}
M.type = "auxiliary"

local timer = 1 -- timer duration in seconds

local startBias = 0
local lastBrakeBiasNeeded = 0
local biasChanged = 0
electrics.values.biasChange = 0
electrics.values.biasDifferent = 0

--sets brake torque for front and rear brakes. Set identical in jbeam using usual brakeStrength and brakeBias arguments as well.
local brakeTorqueFront = 1600
local brakeTorqueRear = 1400

local function updateGFX(dt)
    local biasNeeded = startBias + electrics.values.biasChange
    
    -- screen bias change timer
    if electrics.values.biasDifferent > 0 then
      electrics.values.biasDifferent = electrics.values.biasDifferent - dt
      --print(electrics.values.biasDifferent) --debug
    end

    -- check if bias changed, return if not
    if lastBrakeBiasNeeded == biasNeeded then return end
    lastBrakeBiasNeeded = biasNeeded

      biasChanged = 1
      electrics.values.biasDifferent = timer

    -- gui message
    guihooks.message({txt = string.format("Brake Bias : %.1f%%",biasNeeded*100), context = {}}, 1, "nil", "settings")
    --print(biasNeeded) --debug
    --print(electrics.values.biasChange) --debug

    -- apply
    for _, wd in pairs(wheels.wheels) do
        if wd.name:sub(0,1) == "F" then
            wd.brakeTorque = brakeTorqueFront*biasNeeded
        elseif wd.name:sub(0,1) == "R" then
            wd.brakeTorque = brakeTorqueRear*(1-biasNeeded)
        end
        
    -- limit range (0.49 -> 0.61)
    if biasNeeded > 0.62 then
      electrics.values.biasChange = electrics.values.biasChange - 0.01
    end

    if biasNeeded < 0.49 then
      electrics.values.biasChange = electrics.values.biasChange + 0.01
    end
    
    --send current formatted bias to electrics for use elsewhere
    electrics.values.biasInfo = string.format("%.1f%%",biasNeeded*100)
  end
end

local function init(jbeamData)
    startBias = jbeamData.startBias or 0.55 -- set in jbeam using usual controller formatting
    electrics.values.biasChange = 0
end

M.init = init
M.updateGFX = updateGFX

return M