-- Written by ThatTonybo
-- Credit to Zeit for sound code, camera code and helping overall
local M = {}

M.type = 'auxiliary'
M.relevantDevice = nil

local htmlTexture = require('htmlTexture')
local cruiseControl = require('cruiseControl')

local chimeSound
local beepSound
local soundNode = 0
local camPos
local combinedPos

local lastCruiseData = {
    isEnabled = false,
    targetSpeed = 0
}

local function getCruiseControl()
    if cruiseControl then
        local data = cruiseControl.getConfiguration()
        local newData = { isEnabled = data.isEnabled, targetSpeed = data.targetSpeed }

        if newData == lastCruiseData then return end

        htmlTexture.call('@sharan_gauges_screen', 'cruiseControlUpdate', data)

        lastCruiseData = {
            isEnabled = data.isEnabled,
            targetSpeed = data.targetSpeed
        }
    end
end

local function getRadio()
    if zeitRadio then
        local data = zeitRadio.getCurrentlyPlayingSongData()

        htmlTexture.call('@sharan_gauges_screen', 'radioUpdate', data)
    end
end

local function getTailgateType()
    local type = nil

    if beamstate.nodeNameMap['t3r'] then type = 'tailgate' end
    if beamstate.nodeNameMap['rd3r'] then type = 'rearBarnDoors' end

    return htmlTexture.call('@sharan_gauges_screen', 'setupTailgateType', type)
end

local function isCamInside()
    camPos = obj:getCameraPosition()

    combinedPos = obj:getPosition() + obj:getNodePosition(beamstate.nodeNameMap['driver'] or 0)

    if camPos and combinedPos then
        return camPos:distance(combinedPos) <= 0.6
    end

    return false
end

local function playAlertSound()
    if not isCamInside() then return end

    chimeSound = chimeSound or obj:createSFXSource2('/vehicles/sharan/gauges_screen/sounds/chime.mp3', 'AudioClosest3D', 'sharanChime', soundNode, 0)

    obj:setVolume(chimeSound, 0.4)
    obj:cutSFX(chimeSound)
    obj:playSFX(chimeSound)
end

local function playButtonSound()
    if not isCamInside() then return end

    beepSound = beepSound or obj:createSFXSource2('/vehicles/sharan/gauges_screen/sounds/beep.mp3', 'AudioClosest3D', 'sharanBeep', soundNode, 0)

    obj:setVolume(beepSound, 0.2)
    obj:cutSFX(beepSound)
    obj:playSFX(beepSound)
end

local function changeDynamicContent()
    htmlTexture.call('@sharan_gauges_screen', 'changeDynamicContent')
end

local function dismissActiveAlert()
    htmlTexture.call('@sharan_gauges_screen', 'dismissActiveAlert')
end

local function init(jbeamData)
    electrics.values.oilPanLeak = 0
    electrics.values.highBrakeTemp = 0

    soundNode = beamstate.nodeNameMap['int1l']
end

local function updateGFX(dt)
    if chimeSound ~= nil then
        if not isCamInside() then
            obj:setVolume(chimeSound, 0.0)
        else
            obj:setVolume(chimeSound, 0.4)
        end
    end

    if electrics.values.oilPanLeak ~= 1 then
        if damageTracker.getDamage('engine', 'oilpanLeak') then
            electrics.values.oilPanLeak = 1
        end
    end

    electrics.values.highBraketemp = 0

    for _, v in pairs(electrics.values.wheelThermals) do
        if v.brakeCoreTemperature >= 300 then
            electrics.values.highBrakeTemp = 1
        end
    end
end

M.init = init
M.reset = init
M.updateGFX = updateGFX

M.getCruiseControl = getCruiseControl
M.getRadio = getRadio
M.getTailgateType = getTailgateType
M.playAlertSound = playAlertSound
M.playButtonSound = playButtonSound
M.changeDynamicContent = changeDynamicContent
M.dismissActiveAlert = dismissActiveAlert

scoutGauges = M

return M