local M = {}
local brakeDelayTimer = 0
local brakeDelayThreshold = 0.25
local spawnDelayTimer = 0
local spawnDelayThreshold = 0.01

local function onInit()
    electrics.values.hsa = 1
    electrics.values.hsat = 1
    timer = 0
    brakeDelayTimer = 0
end

local function onReset()
    electrics.values.hsa = 1
    electrics.values.hsat = 1
    timer = 0
    brakeDelayTimer = 0
end 

local function updateGFX(dt)
    timer = timer + dt
	
    if electrics.values.throttle <= 0 and electrics.values.airspeed <= 0.8 / 3.6 and electrics.values.hsat == 1 and electrics.values.hsa == 1 then
        brakeDelayTimer = brakeDelayTimer + dt
        if brakeDelayTimer >= brakeDelayThreshold then
            electrics.values.brake = 0.30 + electrics.values.brake
        end
    else
        electrics.values.brake = 0 + electrics.values.brake
        brakeDelayTimer = 0
    end    

    if electrics.values.hsat == 0 or electrics.values.engineRunning == 0 then
        electrics.values.hsa = 0
    else
        electrics.values.hsa = 1
    end
	
	if electrics.values.ignitionLevel <= 1 and electrics.values.airspeed <= 1.5 / 3.6 then
		electrics.values.parkingbrake = 1 + electrics.values.parkingbrake
		input.parkingbrake = 1 + input.parkingbrake
	else
		electrics.values.parkingbrake = 0 + electrics.values.parkingbrake
		input.parkingbrake = 0 + input.parkingbrake
	end
end

-- public interface

M.onInit = onInit
M.onReset = onInit
M.updateGFX = updateGFX

return M
