local M = {}
local timer = 0

local function onInit()
	electrics.values.airSuspension = 0
	electrics.values.airSuspension_engRunning = 0
	timer = 0
end

local function onReset()
	electrics.values.airSuspension = 0
	electrics.values.airSuspension_engRunning = 0
	timer = 0
end

local function updateGFX(dt)
	if electrics.values.ignitionLevel == 3 then
		timer = timer + dt
		electrics.values.airSuspension_engRunning = 1
	elseif timer >= 0.55 then
		electrics.values.airSuspension_engRunning = 0
		timer = 0 -- Сброс таймера сразу после выполнения условия
	end

	if electrics.values.default_rideHeight == 1 or electrics.values.airspeed > 60 / 3.6 or electrics.values.airSuspension_engRunning == 1 then
		electrics.values.airSuspension = 0
	elseif electrics.values.min_rideHeight == 1 or electrics.values.engineRunning == 0 then
		electrics.values.airSuspension = -0.2
	elseif electrics.values.max_rideHeight == 1 then
		electrics.values.airSuspension = 0.9
	end
end

-- public interface

M.onInit = onInit
M.onReset = onReset
M.updateGFX = updateGFX

return M
