local M = {}
local timer = 0
local timer1 = 0
local delayTimer = 0
local delayTimer1 = 0
local cycleComplete = 0

local function onInit()
    -- Инициализация начальных значений
    for i = 1, 12 do
        electrics.values["as_L_" .. i] = 1
    end
    for i = 1, 12 do
        electrics.values["a_L_" .. i] = 0
    end
	for i = 1, 12 do
        electrics.values["as_R_" .. i] = 1
    end
    for i = 1, 12 do
        electrics.values["a_R_" .. i] = 0
    end
    electrics.values.a_led = 0 -- a_led выключен при инициализации

    timer = 0
    timer1 = 0
    delayTimer = 0
    delayTimer1 = 0
    cycleComplete = 0
end

local function onReset()
    for i = 1, 12 do
        electrics.values["as_L_" .. i] = 0
    end
    for i = 1, 12 do
        electrics.values["a_L_" .. i] = 1
    end
	for i = 1, 12 do
        electrics.values["as_R_" .. i] = 0
    end
    for i = 1, 12 do
        electrics.values["a_R_" .. i] = 1
    end
    electrics.values.a_led = 1 -- a_led включен после сброса

    timer = 0
    timer1 = 0
    delayTimer = 0
    delayTimer1 = 0
    cycleComplete = 0
end

local function resetsignal()
    if electrics.values.ignitionLevel <= 1 then
        -- Выключение всех сигналов при низком уровне зажигания
        for i = 1, 12 do
            electrics.values["as_L_" .. i] = 0
        end
        for i = 1, 12 do
            electrics.values["a_L_" .. i] = 0
        end
		for i = 1, 12 do
            electrics.values["as_R_" .. i] = 0
        end
        for i = 1, 12 do
            electrics.values["a_R_" .. i] = 0
        end
        electrics.values.a_led = 0 -- Выключаем a_led только при низком уровне зажигания
    else
        -- Включение всех сигналов, включая a_L_11
        for i = 1, 12 do
            electrics.values["a_L_" .. i] = 1
        end
		for i = 1, 12 do
            electrics.values["a_R_" .. i] = 1
        end
        electrics.values.a_led = 1 -- Устанавливаем a_led > 1 при нормальном уровне зажигания
    end
end

local function updateGFX(dt)   
    if electrics.values.ignitionLevel <= 1 then
        -- Если уровень зажигания низкий, выключаем все сигналы
        for i = 1, 12 do
            electrics.values["as_L_" .. i] = 0
        end
        for i = 1, 12 do
            electrics.values["a_L_" .. i] = 0
        end
		for i = 1, 12 do
            electrics.values["as_R_" .. i] = 0
        end
        for i = 1, 12 do
            electrics.values["a_R_" .. i] = 0
        end
			electrics.values.a_led = 0		
        return
	else
			electrics.values.a_led = 1	
    end

    if electrics.values.signal_L == 1 then
        -- Анимация поворотника
        for i = 1, 12 do
            electrics.values["a_L_" .. i] = 0
        end
        electrics.values.a_L_11 = 0

        timer = timer + dt
        delayTimer = 0
        
        local delays = {0.0, 0.0250, 0.0500, 0.0750, 0.1000, 0.1250, 0.1500, 0.1750, 0.2000, 0.2250, 0.2500, 0.2750, 0.3000}
        for i = 1, #delays do
            if timer >= delays[i] then
                electrics.values["as_L_" .. i] = 1
            end
        end
    else
        -- Остановка анимации и включение сигналов через 2 секунды
        timer = 0
        delayTimer = delayTimer + dt
        
        for i = 1, 12 do
            electrics.values["as_L_" .. i] = 0
        end

        if delayTimer >= 1.0 then
            for i = 1, 12 do
                electrics.values["a_L_" .. i] = 1
            end
            electrics.values.a_L_13 = 1 -- Включение a_L_11
        end
        
        if delayTimer >= 1.1 then
            delayTimer = 0
        end
    end
	
	if electrics.values.signal_R == 1 then
        -- Анимация поворотника
        for i = 1, 12 do
            electrics.values["a_R_" .. i] = 0
        end
        electrics.values.a_R_12 = 0

        timer1 = timer1 + dt
        delayTimer1 = 0
        
        local delays = {0.0, 0.0250, 0.0500, 0.0750, 0.1000, 0.1250, 0.1500, 0.1750, 0.2000, 0.2250, 0.2500, 0.2750, 0.3000}
        for i = 1, #delays do
            if timer1 >= delays[i] then
                electrics.values["as_R_" .. i] = 1
            end
        end
    else
        -- Остановка анимации и включение сигналов через 2 секунды
        timer1 = 0
        delayTimer1 = delayTimer1 + dt
        
        for i = 1, 12 do
            electrics.values["as_R_" .. i] = 0
        end

        if delayTimer1 >= 1.0 then
            for i = 1, 12 do
                electrics.values["a_R_" .. i] = 1
            end
            electrics.values.a_R_13 = 1 -- Включение a_L_11
        end
        
        if delayTimer1 >= 1.1 then
            delayTimer1 = 0
        end
    end
end

-- public interface
M.onInit = onInit
M.onReset = onReset
M.resetsignal = resetsignal
M.updateGFX = updateGFX

return M
