local M = {}

-- Состояния и таймеры
local strobeState = "idle"       -- Текущее состояние стробоскопа
local strobeTimer = 0            -- Таймер для пауз между циклами
local blinkCount = 0             -- Счетчик миганий
local highbeamCount = 0          -- Счетчик включений дальнего света
local lastHighbeamState = 0      -- Последнее состояние дальнего света
local highbeamTimer = 0          -- Таймер для отслеживания быстрых переключений
local HIGHBEAM_TIMEOUT = 0.5     -- Время (в секундах) для быстрых переключений

local function resetAllFSOLights()
    electrics.values.fso_ul = 0
    electrics.values.fso_ur = 0
    electrics.values.fso_dl = 0
    electrics.values.fso_dr = 0
end

local function onInit()
    resetAllFSOLights()
    strobeState = "idle"
    strobeTimer = 0
    blinkCount = 0
    highbeamCount = 0
    lastHighbeamState = 0
    highbeamTimer = 0
end

local function onReset()
    onInit()
end

local function updateGFX(dt)
    -- Обновляем таймер быстрых переключений
    if highbeamTimer > 0 then
        highbeamTimer = highbeamTimer - dt
        if highbeamTimer <= 0 then
            -- Время вышло, сбрасываем счетчик
            highbeamCount = 0
            highbeamTimer = 0
        end
    end

    -- Обнаружение нажатия дальнего света
    if electrics.values.highbeam ~= lastHighbeamState then
        if electrics.values.highbeam == 1 then
            -- Если таймер еще не запущен, запускаем его
            if highbeamTimer <= 0 then
                highbeamTimer = HIGHBEAM_TIMEOUT
                highbeamCount = 1
            else
                -- Таймер уже идет, увеличиваем счетчик
                highbeamCount = highbeamCount + 1
            end
        end
        lastHighbeamState = electrics.values.highbeam
    end

    -- Если было 2 или более нажатий в течение 2 секунд, запускаем стробоскоп
    if highbeamCount >= 2 and strobeState == "idle" then
        strobeState = "first_pair"
        strobeTimer = 0
        highbeamCount = 0
        highbeamTimer = 0  -- Сбрасываем таймер
    end

    -- Остальной код обработки состояний стробоскопа остается без изменений
    if strobeState ~= "idle" then
        strobeTimer = strobeTimer + dt

        if strobeState == "first_pair" then
            -- Мигаем UL и DR 3 раза (0.05 сек вкл, 0.05 сек выкл)
            local cycle = math.floor(strobeTimer / 0.1) -- полный цикл 0.1 сек
            local phase = strobeTimer % 0.1

            if cycle < 3 then
                if phase < 0.05 then
                    electrics.values.fso_ul = 1
                    electrics.values.fso_dr = 1
                    electrics.values.fso_ur = 0
                    electrics.values.fso_dl = 0
                else
                    resetAllFSOLights()
                end
            else
                if strobeTimer >= 0.3 + 0.5 then -- 3 мигания (0.3 сек) + пауза 0.5 сек
                    strobeState = "second_pair"
                    strobeTimer = 0
                    blinkCount = 0
                end
            end

        elseif strobeState == "second_pair" then
            -- Мигаем UR и DL 3 раза
            local cycle = math.floor(strobeTimer / 0.1)
            local phase = strobeTimer % 0.1

            if cycle < 3 then
                if phase < 0.05 then
                    electrics.values.fso_ur = 1
                    electrics.values.fso_dl = 1
                    electrics.values.fso_ul = 0
                    electrics.values.fso_dr = 0
                else
                    resetAllFSOLights()
                end
            else
                if strobeTimer >= 0.3 + 0.5 then
                    strobeState = "third_pair"
                    strobeTimer = 0
                    blinkCount = 0
                end
            end

        elseif strobeState == "third_pair" then
            -- Мигаем UL и UR 3 раза
            local cycle = math.floor(strobeTimer / 0.1)
            local phase = strobeTimer % 0.1

            if cycle < 3 then
                if phase < 0.05 then
                    electrics.values.fso_ul = 1
                    electrics.values.fso_ur = 1
                    electrics.values.fso_dl = 0
                    electrics.values.fso_dr = 0
                else
                    resetAllFSOLights()
                end
            else
                if strobeTimer >= 0.3 + 0.5 then
                    strobeState = "fourth_pair"
                    strobeTimer = 0
                    blinkCount = 0
                end
            end

        elseif strobeState == "fourth_pair" then
            -- Мигаем DL и DR 3 раза
            local cycle = math.floor(strobeTimer / 0.1)
            local phase = strobeTimer % 0.1

            if cycle < 3 then
                if phase < 0.05 then
                    electrics.values.fso_dl = 1
                    electrics.values.fso_dr = 1
                    electrics.values.fso_ul = 0
                    electrics.values.fso_ur = 0
                else
                    resetAllFSOLights()
                end
            else
                if strobeTimer >= 0.3 + 0.5 then
                    strobeState = "idle"
                    resetAllFSOLights()
                end
            end
        end
    end
end

-- public interface
M.onInit      = onInit
M.onReset     = onReset
M.updateGFX   = updateGFX

return M