-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt
local M = {}

local dInletTemp = 0
local lossFactor = 1.2
local combustionTemp = 0
local dTempWarn = 0

function updateGFX(dt)
	combustionTemp = (powertrain.getDevice("mainEngine").thermals.cylinderWallTemperature + powertrain.getDevice("mainEngine").thermals.exhaustTemperature) / 2
	dInletTemp = combustionTemp * lossFactor
	if dInletTemp > 960 then
		dTempWarn = 1
	end
	electrics.values.dInletTemp = dInletTemp
	electrics.values.dTempWarn = dTempWarn
end

-- public interface
M.dInletTemp = dInletTemp
M.dTempWarn = dTempWarn

M.updateGFX = updateGFX

return M