-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt
local M = {}
local roofActive = 0
local dTrunk = 0
local dRoof = 0
local dFlip = 0

local roofStage = 0
local roofDirection = 1 -- 0 is up, 1 is down

local function dToggleRoof()
	if roofDirection == 1 then
		roofDirection = 0
	else
		roofDirection = 1
	end
	if roofActive == 0 then
		roofActive = 1
		roofStage = 1
	end
end

local function updateGFX(dt)

    if roofActive == 1 then
		if roofDirection == 0 then
			if roofStage == 1 then
				dTrunk = dTrunk + 0.002
				if dTrunk >= 1 then
					dTrunk = 1
					roofStage = 2
				end
			elseif roofStage == 2 then
				dRoof = dRoof + 0.0007
				if dRoof >= 1 then
					dRoof = 1
					roofStage = 3
				end
			elseif roofStage == 3 then
				dFlip = dFlip + 0.001
				if dFlip >= 1 then
					dFlip = 1
					roofStage = 4
				end
			elseif roofStage == 4 then
				dTrunk = dTrunk - 0.002
				if dTrunk <= 0 then
					dTrunk = 0
					roofStage = 0
					roofActive = 0
				end
			end
		end
	end

    if roofActive == 1 then
		if roofDirection == 1 then
			if roofStage == 1 then
				dTrunk = dTrunk + 0.002
				if dTrunk >= 1 then
					dTrunk = 1
					roofStage = 2
				end
			elseif roofStage == 2 then
				dRoof = dRoof - 0.0007
				if dRoof <= 0 then
					dRoof = 0
					roofStage = 3
				end
			elseif roofStage == 3 then
				dFlip = dFlip - 0.001
				if dFlip <= 0 then
					dFlip = 0
					roofStage = 4
				end
			elseif roofStage == 4 then
				dTrunk = dTrunk - 0.002
				if dTrunk <= 0 then
					dTrunk = 0
					roofStage = 0
					roofActive = 0
				end
			end
		end
	end
	
    electrics.values.dTrunk = dTrunk
    electrics.values.dRoof = dRoof
    electrics.values.dFlip = dFlip
end

local function onReset()
    dTrunk = 0
    dRoof = 0
    dFlip = 0
    roofStage = 0
    roofActive = 0
end

-- public interface
M.onReset = onReset
M.onInit = onInit

M.dTrunk = dTrunk
M.dRoof = dRoof
M.dFlip = dFlip
M.dToggleRoof = dToggleRoof

M.updateGFX = updateGFX

return M