-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt
-- active center differencial 

local M = {}
M.type = "auxilliary"
M.relevantDevice = "differential"

local wheels = {} --cache for holding all our wheels
local otherWheelOnAxle = {}

local frontLeftWheelName = ""
local frontRightWheelName = ""
local rearRightWheelName = ""
local rearLeftWheelName = ""


local transfercase = nil
local diffMode = 0
local diffLockPow = 0.05
local oldDiffLockCoef = 0
local newDiffLockCoef = 0
local diffLockSmooth = 0.5

local function updateGFX()
  if not transfercase then return end
  
  local throttle = electrics.values['throttle_input']
  local brake = electrics.values['brake_input']
  local steer = electrics.values['steering_input']
  local absSteer = math.abs(steer)
  local lateralG = sensors.gx2
  local absLateralG = math.abs(lateralG)
  
  local wheelSpeeds = {}
  
  local frontAxleAveSpeed = 0
  local rearAxleAveSpeed = 0
  
  for _,w in pairs(powertrain.wheels) do
	local wheelSpeed = w.speedSmoother:get(w.angularVelocity * w.wheelDir)
	wheelSpeeds[w.name] = wheelSpeed
	--log('I', "Wheel Name ", w.name)
  end
  
  frontAxleAveSpeed = (wheelSpeeds[frontLeftWheelName] + wheelSpeeds[frontRightWheelName]) * 0.5
  --frontAxleAveSpeed = math.min(wheelSpeeds[frontLeftWheelName], wheelSpeeds[frontRightWheelName])
  rearAxleAveSpeed = (wheelSpeeds[rearLeftWheelName] + wheelSpeeds[rearRightWheelName]) * 0.5
  
  local axleSpeedRatio = rearAxleAveSpeed / frontAxleAveSpeed
  local axleSpeedDiff = rearAxleAveSpeed - frontAxleAveSpeed
  
  if electrics.values['diffMode'] == 0 then  --Tarmac
  --local maxGLockUp = 0.35 * math.pow(throttle, 0.71)
  --local minGLockUp = math.pow(throttle, 2.1)
  --newDiffLockCoef = maxGLockUp * absLateralG + minGLockUp * (1-absLateralG)
  --transfercase.lsdLockCoef =  transfercase.lsdLockCoef * diffLockSmooth + newDiffLockCoef * (1.0-diffLockSmooth)
  --transfercase.diffLockSplit = 0.5 
  --log('I', "Transfercase", " Tarmac")
  
  local slideLockUp = math.pow(math.min(math.abs(lateralG/11 + steer), 1.0), 1.0)
  --local frontPowerBias = math.min((math.max((axleSpeedRatio - 1.05),0) * 10.0), 1)
  --transfercase.lsdLockCoef = math.min((frontPowerBias * 0.9),1)
  transfercase.lsdLockCoef = math.max((0.5 - 0.5 * slideLockUp),0)
  --transfercase.diffTorqueSplitA = 1- slideLockUp
  transfercase.diffTorqueSplitA = 0.5
  transfercase.diffTorqueSplitB = 1 - transfercase.diffTorqueSplitA
  transfercase.lsdPreload = 10 + math.max(throttle, brake) * 200 * (1.0 - math.pow(absSteer, 1))
  end 
  
  if electrics.values['diffMode'] == 1 then  --Dirt
  local slideLockUp = math.pow(math.min(math.abs(lateralG/11 + steer), 1.0), 1.0)
  --transfercase.lsdLockCoef = 0.1 + math.max(throttle, brake) * 0.4 * (1.0 - math.pow(absSteer, 1))
  transfercase.lsdLockCoef = 0.1 + math.max((0.3 - 0.3 * slideLockUp),0)
  transfercase.diffTorqueSplitA = 0.5
  transfercase.diffTorqueSplitB = 1 - transfercase.diffTorqueSplitA
  --transfercase.lsdPreload = 50
  transfercase.lsdPreload = 8 + math.max(throttle, brake * 0.5) * 75 * (1.0 - math.pow(absSteer, 0.7))
  log('I', "Transfercase", " Dirt")
  end
  
  if electrics.values['diffMode'] == 2 then --Snow
  transfercase.lsdLockCoef = clamp(math.abs(axleSpeedDiff) * 0.02,0,0.5)
  transfercase.diffTorqueSplitA = 0.5
  transfercase.diffTorqueSplitB = 1 - transfercase.diffTorqueSplitA
  log('I', "Transfercase", " Snow")
  transfercase.lsdPreload = 1
  end
  
  if electrics.values['diffMode'] == 3 then --Drift
  transfercase.lsdLockCoef = 0.0
  transfercase.diffTorqueSplitA = 0.99 - 0.49 * clamp(10 * absSteer - 8.5,0,1) * clamp((steer * lateralG * 100),0,1)
  transfercase.diffTorqueSplitB = 1 - transfercase.diffTorqueSplitA
  transfercase.lsdPreload = 5
  log('I', "Transfercase", " Drift")
  end
  
  if input.parkingbrake > 0.5 then
    transfercase.lsdLockCoef = 0
  end  
    
	transfercase.lsdRevLockCoef = transfercase.lsdLockCoef
	
  local split = string.format("%.2f", transfercase.diffTorqueSplit)
  local lock = string.format("%.2f", transfercase.lsdLockCoef) 
  local output1 = string.format("%.2f", transfercase.outputAV1)
  local slide = string.format("%.2f", lateralG/9.8 + steer)
  --log('I', "Torque Split ", split)
  --log('I', "Diff Lock ", lock)
  --log('I', "Diff Output1 ", output1)
  --log('I', "Slide ", slide)
  
  
end


local function init(jbeamData)
  transfercase = powertrain.getDevice(jbeamData.transfercaseName)
  if transfercase then
    transfercase.lsdLockCoef = 0.10
	transfercase.lsdRevLockCoef = 0.10
	transfercase.diffTorqueSplit = 0.98
	electrics.values['diffMode'] = 0
  end
  
  local avgWheelPos = vec3(0,0,0)
  local wheelCount = 0
  wheels = {}
  
  for _,wd in pairs(powertrain.wheels) do
    local name = wd.name
    wheels[name] = wd
    wheels[name].speedSmoother =  newExponentialSmoothing(500)
    --log('I', "Wheel Name ", name)
  end
  
  
  for _,w in pairs(powertrain.wheels) do
    
    local wheelNodePos = v.data.nodes[wheels[w.name].node1].pos --find the wheel position
    avgWheelPos = avgWheelPos + wheelNodePos --sum up all positions
    wheelCount = wheelCount + 1
  end
  
  local vectorForward = vec3(v.data.nodes[v.data.refNodes[0].ref].pos) - vec3(v.data.nodes[v.data.refNodes[0].back].pos) -- vec3(obj:getDirectionVector()) --vector facing forward
  local vectorUp = vec3(v.data.nodes[v.data.refNodes[0].up].pos) - vec3(v.data.nodes[v.data.refNodes[0].ref].pos)

  local vectorRight = vectorForward:cross(vectorUp) --vector facing to the right

  --iterate over all wheels 
  for _,w in pairs(powertrain.wheels) do
    local wheelNodePos = vec3(v.data.nodes[wheels[w.name].node1].pos) --find the wheel position
    local wheelVector = wheelNodePos - avgWheelPos --create a vector from our "center" to the wheel
    local dotForward = vectorForward:dot(wheelVector) --calculate dot product of said vector and forward vector
    local dotLeft = vectorRight:dot(wheelVector) --calculate dot product of said vector and left vector

    if dotForward >= 0 then
      if dotLeft >= 0 then
        
		frontRightWheelName = w.name --this case can only mean it's our front right wheel
      else
        frontLeftWheelName = w.name -- ...
      end
    else
      if dotLeft >= 0 then
        rearRightWheelName = w.name-- ...
      else
        rearLeftWheelName = w.name-- ...
      end
    end
  end
  
  --frontRightWheelName = "FR"
  --frontLeftWheelName = "FL"
  --rearRightWheelName = "RR"
  --rearLeftWheelName = "RL"
  
  
  
  
end

M.init = init
--M.reset = init
M.updateGFX = updateGFX


return M