-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt
-- active yaw control

local M = {}
M.type = "auxilliary"
M.relevantDevice = "differential"

local wheels = {} --cache for holding all our wheels
local otherWheelOnAxle = {}

local frontLeftWheelName = ""
local frontRightWheelName = ""
local rearRightWheelName = ""
local rearLeftWheelName = ""

local differential = nil
local diffLockCoef = 0.05

local function updateGFX()
  if not differential then return end
  local throttle = electrics.values['throttle_input'];
  local steer = electrics.values['steering_input'];
  local absSteer = math.abs(steer);
  local lateralG = sensors.gx2
  local absLateralG = math.abs(lateralG)

  local wheelSpeeds = {}
  
  local frontAxleAveSpeed = 0
  local rearAxleAveSpeed = 0
  
  for _,w in pairs(powertrain.wheels) do
	local wheelSpeed = w.speedSmoother:get(w.angularVelocity * w.wheelDir)
	wheelSpeeds[w.name] = wheelSpeed
	--log('I', "Wheel Name ", w.name)
  end
  
  --frontAxleAveSpeed = (wheelSpeeds[frontLeftWheelName] + wheelSpeeds[frontRightWheelName]) * 0.5
  --rearAxleAveSpeed = (wheelSpeeds[rearLeftWheelName] + wheelSpeeds[rearRightWheelName]) * 0.5
  local rearSpeedDiff = (wheelSpeeds[rearLeftWheelName] - wheelSpeeds[rearRightWheelName])
  local steerDirectionCoef = clamp(steer * 10,-1,1)
  local sideAccelDirectionCoef = clamp(- lateralG * 1,-1,1)

  if electrics.values['diffMode'] == 0 then  --Tarmac

  --diffLockCoef = throttle * math.pow(absSteer, 0.3) * 0.2
  diffLockCoef = 0.2
  --differential.diffTorqueSplitA = throttle * math.pow((steer * 0.5 + 0.5), 1)
  differential.diffTorqueSplitA = clamp(((steer - lateralG/11) * 0.5 * clamp(throttle * 10,0,1) + 0.5), 0.25, 0.75)
  --differential.diffTorqueSplitA = 0.5
  differential.lsdPreload = 50
  log('I', "Mode", "Tarmac")  
  end 
  if electrics.values['diffMode'] == 1 then  --Dirt
  --diffLockCoef = 0.4 * throttle
  diffLockCoef = clamp( - rearSpeedDiff * 0.02 * sideAccelDirectionCoef,0,0.5)
  --differential.diffTorqueSplitA = 0.5
  differential.diffTorqueSplitA = clamp(((steer - lateralG/8) * 0.5 + 0.5), 0.35, 0.65)
  differential.lsdPreload = 50
  end
  if electrics.values['diffMode'] == 2 then --Snow
  diffLockCoef = clamp( - rearSpeedDiff * 0.02 * steerDirectionCoef,0,0.5)
  differential.diffTorqueSplitA = clamp((steer * 0.5 + 0.5), 0.35, 0.65)
  differential.lsdPreload = math.abs(rearSpeedDiff * 1)
  end
  if electrics.values['diffMode'] == 3 then --Drift
  diffLockCoef = 0.3 * throttle * (1 - math.pow(absSteer, 3))
  differential.diffTorqueSplitA = 0.5
  --differential.diffTorqueSplitA = throttle * math.pow((steer * 0.5 + 0.5), 1) 
 differential.lsdPreload = 100
  end
  
  differential.lsdLockCoef = diffLockCoef
  differential.diffTorqueSplitB = 1 - differential.diffTorqueSplitA
  differential.lsdRevLockCoef = differential.lsdLockCoef
  
end

local function init(jbeamData)
  differential = powertrain.getDevice(jbeamData.transfercaseName)
  if differential then 
  log('I', "Found", "Rear Diff")
  differential.lsdLockCoef = 0.1
  differential.lsdRevLockCoef = 0.05
  differential.lsdPreLoad = 20
  differential.diffTorqueSplit = 0.5
  end

  local avgWheelPos = vec3(0,0,0)
  local wheelCount = 0
  wheels = {}
  
  for _,wd in pairs(powertrain.wheels) do
    local name = wd.name
    wheels[name] = wd
    wheels[name].speedSmoother =  newExponentialSmoothing(500)
    --log('I', "Wheel Name ", name)
  end
  
  
  for _,w in pairs(powertrain.wheels) do
    
    local wheelNodePos = v.data.nodes[wheels[w.name].node1].pos --find the wheel position
    avgWheelPos = avgWheelPos + wheelNodePos --sum up all positions
    wheelCount = wheelCount + 1
  end
  
  local vectorForward = vec3(v.data.nodes[v.data.refNodes[0].ref].pos) - vec3(v.data.nodes[v.data.refNodes[0].back].pos) -- vec3(obj:getDirectionVector()) --vector facing forward
  local vectorUp = vec3(v.data.nodes[v.data.refNodes[0].up].pos) - vec3(v.data.nodes[v.data.refNodes[0].ref].pos)

  local vectorRight = vectorForward:cross(vectorUp) --vector facing to the right

  --iterate over all wheels 
  for _,w in pairs(powertrain.wheels) do
    local wheelNodePos = vec3(v.data.nodes[wheels[w.name].node1].pos) --find the wheel position
    local wheelVector = wheelNodePos - avgWheelPos --create a vector from our "center" to the wheel
    local dotForward = vectorForward:dot(wheelVector) --calculate dot product of said vector and forward vector
    local dotLeft = vectorRight:dot(wheelVector) --calculate dot product of said vector and left vector

    if dotForward >= 0 then
      if dotLeft >= 0 then
        
		frontRightWheelName = w.name --this case can only mean it's our front right wheel
      else
        frontLeftWheelName = w.name -- ...
      end
    else
      if dotLeft >= 0 then
        rearRightWheelName = w.name-- ...
      else
        rearLeftWheelName = w.name-- ...
      end
    end
  end
  
  --frontRightWheelName = "FR"
  --frontLeftWheelName = "FL"
  --rearRightWheelName = "RR"
  --rearLeftWheelName = "RL"

end

M.init = init
--M.reset = init
M.updateGFX = updateGFX

return M