-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt
local M = {}
M.type = "auxiliary"
local map_R = 0
local map_L = 0
local vent_R = 0
local vent_L = 0
local beams = 0
local starting = 0
local window_active = nil

local window_FR = 0
local window_FL = 0
local window_RR = 0
local window_RL = 0

local function dToggleLights()
    if beams == 1 or beams == 2 then
        beams = 0
    else
        beams = 1
    end
    electrics.setLightsState(beams)
end

local function dToggleMapR()
    map_R = 1 - map_R
end

local function dToggleMapL()
    map_L = 1 - map_L
end

local function dVentR()
    vent_R = 1 - vent_R
end

local function dVentL()
    vent_L = 1 - vent_L
end

local function dIgn()
    if starting == 1 or starting == 2 then
        starting = 0
    else
        starting = 1
    end
	electrics.setIgnitionState(starting)
end

local function dWindowUpFRStart() window_active = 'FRup' end
local function dWindowDownFRStart() window_active = 'FRdown' end
local function dWindowUpFRStop() window_active = nil end
local function dWindowDownFRStop() window_active = nil end

local function dWindowUpFLStart() window_active = 'FLup' end
local function dWindowDownFLStart() window_active = 'FLdown' end
local function dWindowUpFLStop() window_active = nil end
local function dWindowDownFLStop() window_active = nil end

local function dWindowUpRRStart() window_active = 'RRup' end
local function dWindowDownRRStart() window_active = 'RRdown' end
local function dWindowUpRRStop() window_active = nil end
local function dWindowDownRRStop() window_active = nil end

local function dWindowUpRLStart() window_active = 'RLup' end
local function dWindowDownRLStart() window_active = 'RLdown' end
local function dWindowUpRLStop() window_active = nil end
local function dWindowDownRLStop() window_active = nil end

local function updateGFX(dt)

    if window_active == 'FRup' and window_FR > 0 then
		window_FR = window_FR - 0.005
		if window_FR < 0 then
			window_FR = 0
		end
	end
    if window_active == 'FRdown' and window_FR < 1 then
		window_FR = window_FR + 0.005
		if window_FR > 1 then
			window_FR = 1
		end
	end

    if window_active == 'FLup' and window_FL > 0 then
		window_FL = window_FL - 0.005
		if window_FL < 0 then
			window_FL = 0
		end
	end
    if window_active == 'FLdown' and window_FL < 1 then
		window_FL = window_FL + 0.005
		if window_FL > 1 then
			window_FL = 1
		end
	end

    if window_active == 'RRup' and window_RR > 0 then
		window_RR = window_RR - 0.005
		if window_RR < 0 then
			window_RR = 0
		end
	end
    if window_active == 'RRdown' and window_RR < 1 then
		window_RR = window_RR + 0.005
		if window_RR > 1 then
			window_RR = 1
		end
	end

    if window_active == 'RLup' and window_RL > 0 then
		window_RL = window_RL - 0.005
		if window_RL < 0 then
			window_RL = 0
		end
	end
    if window_active == 'RLdown' and window_RL < 1 then
		window_RL = window_RL + 0.005
		if window_RL > 1 then
			window_RL = 1
		end
	end
	
    electrics.values.map_R = map_R
    electrics.values.map_L = map_L
    electrics.values.vent_R = vent_R
    electrics.values.vent_L = vent_L
    electrics.values.window_FR = window_FR
    electrics.values.window_FL = window_FL
    electrics.values.window_RR = window_RR
    electrics.values.window_RL = window_RL
end

local function onReset()
    window_FR = 0
    window_FL = 0
    window_RR = 0
    window_RL = 0
end

-- public interface
M.onReset = onReset
M.onInit = onInit

M.dToggleLights = dToggleLights
M.dToggleMapR = dToggleMapR
M.dToggleMapL = dToggleMapL
M.dVentR = dVentR
M.dVentL = dVentL

M.dIgn = dIgn

M.dWindowUpFRStart = dWindowUpFRStart
M.dWindowUpFRStop = dWindowUpFRStop
M.dWindowDownFRStart = dWindowDownFRStart
M.dWindowDownFRStop = dWindowDownFRStop
M.dWindowUpFLStart = dWindowUpFLStart
M.dWindowUpFLStop = dWindowUpFLStop
M.dWindowDownFLStart = dWindowDownFLStart
M.dWindowDownFLStop = dWindowDownFLStop
M.dWindowUpRRStart = dWindowUpRRStart
M.dWindowUpRRStop = dWindowUpRRStop
M.dWindowDownRRStart = dWindowDownRRStart
M.dWindowDownRRStop = dWindowDownRRStop
M.dWindowUpRLStart = dWindowUpRLStart
M.dWindowUpRLStop = dWindowUpRLStop
M.dWindowDownRLStart = dWindowDownRLStart
M.dWindowDownRLStop = dWindowDownRLStop

M.updateGFX = updateGFX

return M