-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt

local M = {}
local clamp = clamp

local function onReset()
  electrics.values.tilt = 0
  electrics.values.tilt_input = 0
  electrics.values.extend = 0
  electrics.values.extend_input = 0
  electrics.values.feet = 0
  electrics.values.feet_input = 0
end

local function updateGFX(dt) -- ms
  electrics.values.tilt = clamp(electrics.values.tilt + electrics.values.tilt_input * dt * 0.25, 0, 1)
  electrics.values.extend = clamp(electrics.values.extend + electrics.values.extend_input * dt * 0.25, 0, 1)
  electrics.values.feet = clamp(electrics.values.feet + electrics.values.feet_input * dt * 1.25, 0, 1)
end

local function tiltBed(value)
  electrics.values.tilt_input = value
end

local function extendBed(value)
  electrics.values.extend_input = value
end

local function extendFeet(value)
  electrics.values.feet_input = value
end

-- public interface
M.onInit    = onReset
M.onReset   = onReset
M.updateGFX = updateGFX
M.tiltBed = tiltBed
M.extendBed = extendBed
M.extendFeet = extendFeet

return M
