-- Define the angle threshold for detecting a wheelie (in degrees)
local wheelieThreshold = 15

-- Define the power reduction factor when a wheelie is detected (0 to 1)
local powerReductionFactor = 0.8  -- 80% of the original power

-- Function to check if the vehicle is in a wheelie position
local function isWheelie()
    local pitch = obj:getRoll()  -- Get the pitch angle (rotation around the X-axis)
    return math.deg(math.abs(pitch)) > wheelieThreshold
end

-- Function to adjust the car's power based on wheelie detection
local function adjustPower()
    if isWheelie() then
        -- Reduce the car's power
        local originalThrottle = electrics.values.throttleInput
        electrics.values.throttleInput = originalThrottle * powerReductionFactor
    else
        -- Restore the car's power to the original value
        electrics.values.throttleInput = electrics.values.throttleInput
    end
end

-- Register the update function to be called every frame
function update()
    adjustPower()
end
