-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt

local M = {}
M.type = "auxiliary"

local cabinFilterCoef = 1
local cabinFilterChanged = false

-- Table for door couplers and corresponding courtesy lights
local doorConfigs = {
  {coupler = "doorFLCoupler_notAttached", light = "flcourtesylight"},
  {coupler = "doorFRCoupler_notAttached", light = "frcourtesylight"},
  {coupler = "doorRLCoupler_notAttached", light = "rlcourtesylight"},
  {coupler = "doorRRCoupler_notAttached", light = "rrcourtesylight"}
}

local function updateGFX(dt)
    local vals = electrics.values
    local doorAjar = false

    -- Loop through all door couplers
    for _, config in ipairs(doorConfigs) do
        local ajar = vals[config.coupler] and vals[config.coupler] > 0
        electrics.values[config.light] = ajar and 1 or 0
        doorAjar = doorAjar or ajar
    end

    if doorAjar then
        if not cabinFilterChanged then
			vals["domelight"] = 1
            obj:queueGameEngineLua(string.format("core_sounds.cabinFilterStrength = %f", 0))--Disable 1st-person sound muffling
            cabinFilterChanged = true
        end
    else
        if cabinFilterChanged then
			vals["domelight"] = 0
            obj:queueGameEngineLua(string.format("core_sounds.cabinFilterStrength = %f", cabinFilterCoef))--Re-enable 1st person sound muffling
            cabinFilterChanged = false
        end
    end
end

local function init(jbeamData)
    if v.data.sounds then
        cabinFilterCoef = v.data.sounds.cabinFilterCoef or 1
        print(cabinFilterCoef)
    end
end

M.init = init
M.updateGFX = updateGFX

return M
