-- Additional functions made by AR162b for BeamNG.Drive
-- Specially designed for SergentFido's Olds

local M = {}


local lightsPDState = 0
--local ToggledPD = false
--local ToggledAlley = false
--local ToggledTaxi = false
--local PDlights = 0
local blinkPDTimerThreshold = 0.4
local blinkPDTimerThresholdHalf = 0
local blinkPDTimer = 0
local blinkPDTimerShort = 0
local blinkPDTimerMode = 0
local blinkshorttime = 0.07
local TaxiLight = 0
local BlinkSignalTimerShort = 0
local BlinkSignalShortTime = 0.1
local blinkSignal1 = 0
local blinkSignal2 = 0
local blinkSignal3 = 0
local blinkSignal4 = 0
local blinkSignal5 = 0
local blinkSignal6 = 0
local blinkSignal7 = 0
local blinkSignal8 = 0
local blinkPDModeA = 0
local blinkPDModeB = 1
local PDW = 0
local blinkPDTimer = 0
local blinkPDPulseLeft = 0
local blinkPDPulseRight = 0
local blinkPDPulseShortLeft = 0
local blinkPDPulseShortRight = 0
local openTailGateTimer = 0
local tailGateOpens = 0
local tailGateMode = 0
local tailGateModeTimer = 150


local function onInit()
	electrics.values['PDa'] = 0
	electrics.values['alley_steer'] = 0
	electrics.values['alley_steerR'] = 0
	electrics.values['PD_R'] = 0
	electrics.values['PD_L'] = 0
	electrics.values['PD_short_R'] = 0
	electrics.values['PD_short_L'] = 0
	electrics.values['taxisign'] = 0
	electrics.values['taxiOD'] = 0
	electrics.values['spinright'] = 0
	electrics.values['spinleft'] = 0
	electrics.values['cornerLight_L'] = 0
	electrics.values['cornerLight_R'] = 0
	electrics.values['TaxiLights'] = 0
	electrics.values['openTailGateImmediate'] = 0
	electrics.values['openTailGateDelaySide'] = 0
	electrics.values['openTailGateDelayDown'] = 0
end

local function reset()
	onInit()
end


local function generateBlinkPDTimer(dt)

    blinkPDTimerThresholdHalf = (blinkPDTimerThreshold / 2)

    blinkPDTimer = blinkPDTimer + (dt)

    if blinkPDTimer > blinkPDTimerThreshold then
        blinkPDTimer = blinkPDTimer - blinkPDTimerThreshold
	blinkPDPulseLeft = 0
	blinkPDPulseRight = 1
	elseif blinkPDTimer > blinkPDTimerThresholdHalf then
	blinkPDPulseLeft = 1
	blinkPDPulseRight = 0
    end
end

local function generateBlinkPDTimerMode(dt)

    blinkPDTimerMode = blinkPDTimerMode + (dt)

    if blinkPDTimerMode > 7 then
    blinkPDTimerMode = blinkPDTimerMode - 7
	blinkPDModeA = 0
	blinkPDModeB = 1
	elseif blinkPDTimerMode > 5 then
	blinkPDModeA = 1
	blinkPDModeB = 0
	end
end

local function generateBlinkPDTimerShort(dt)

    blinkPDTimerShort = blinkPDTimerShort + (dt)

    if blinkPDTimerShort > (8*blinkshorttime) then
	blinkPDTimerShort = 0
	blinkPDPulseShortLeft = 0
	blinkPDPulseShortRight = 1

    elseif
    blinkPDTimerShort > (7*blinkshorttime) then
	blinkPDPulseShortLeft = 0
	blinkPDPulseShortRight = 0

    elseif
    blinkPDTimerShort > (6*blinkshorttime) then
	blinkPDPulseShortLeft = 0
	blinkPDPulseShortRight = 1

    elseif
    blinkPDTimerShort > (5*blinkshorttime) then
	blinkPDPulseShortLeft = 0
	blinkPDPulseShortRight = 0

    elseif
    blinkPDTimerShort > (4*blinkshorttime) then
	blinkPDPulseShortLeft = 1
	blinkPDPulseShortRight = 0

    elseif
    blinkPDTimerShort > (3*blinkshorttime) then
	blinkPDPulseShortLeft = 0
	blinkPDPulseShortRight = 0

    elseif
    blinkPDTimerShort > (2*blinkshorttime) then
	blinkPDPulseShortLeft = 1
	blinkPDPulseShortRight = 0

    elseif
    blinkPDTimerShort > (1*blinkshorttime) then
	blinkPDPulseShortLeft = 0
	blinkPDPulseShortRight = 0

    end
    end



local function updateGFX(dt)
    local vals = M.values
    generateBlinkPDTimer(dt)
    generateBlinkPDTimerShort(dt)	
    generateBlinkPDTimerMode(dt)
	


			if electrics.values['TaxiLights'] == 2 then
				--gui.message("Taxi Lights off")
				electrics.values['taxisign'] = 0
				electrics.values['taxiOD'] = 0
				TaxiLight = 0

		
			elseif electrics.values['TaxiLights'] == 1 then
				--gui.message("Taxi Lights Off-Duty")
				electrics.values['taxisign'] = 0
				electrics.values['taxiOD'] = 1
				TaxiLight = TaxiLight + 1
				
			else
				--gui.message("Taxi Lights on")
				electrics.values['taxisign'] = 1
				electrics.values['taxiOD'] = 0
				TaxiLight = TaxiLight + 1
				electrics.values['TaxiLights'] = 0

			end

			if (electrics.values['openTailGate'] == 1 and tailGateModeTimer >150 and tailGateOpens == 0) then
				tailGateOpens = 1
				tailGateMode = 0
				tailGateModeTimer = 0
			elseif (electrics.values['openTailGate'] == 0 and  tailGateModeTimer <50 and tailGateOpens == 1) then
					electrics.values['openTailGate'] = 1
					tailGateOpens = 1
					tailGateMode = 1
					tailGateModeTimer = 0
			elseif (electrics.values['openTailGate'] == 0 and tailGateModeTimer >150 and tailGateOpens == 1) then
					electrics.values['openTailGate'] = 0
					tailGateOpens = 0
					tailGateMode = 0
					tailGateModeTimer = 0
			elseif tailGateModeTimer > 3000 then
				tailGateModeTimer = 3000
			elseif (electrics.values['openTailGate'] == 1 and tailGateModeTimer <150 and tailGateOpens == 0) then
					electrics.values['openTailGate'] = 0
			else				
				tailGateModeTimer = tailGateModeTimer + 1
			end
	
			
			if (tailGateOpens == 1 and openTailGateTimer < 1) then
				electrics.values['openTailGateImmediate'] = 1
				electrics.values['openTailGateDelaySide'] = 0
				electrics.values['openTailGateDelayDown'] = 0				
				openTailGateTimer = openTailGateTimer + 0.01
			elseif (tailGateOpens == 1 and openTailGateTimer >= 1) then
				electrics.values['openTailGateImmediate'] = 1
				electrics.values['openTailGateDelaySide'] = 1 * tailGateMode
				electrics.values['openTailGateDelayDown'] = 1 * (1- tailGateMode)
				openTailGateTimer = 1
			elseif (tailGateOpens == 0 and openTailGateTimer > 0) then
				electrics.values['openTailGateImmediate'] = 1
				electrics.values['openTailGateDelaySide'] = 0
				electrics.values['openTailGateDelayDown'] = 0
				openTailGateTimer = openTailGateTimer - 0.01
			elseif (tailGateOpens == 0 and openTailGateTimer <= 0) then
				electrics.values['openTailGateImmediate'] = 0
				electrics.values['openTailGateDelaySide'] = 0
				electrics.values['openTailGateDelayDown'] = 0
				openTailGateTimer = 0
			else
				electrics.values['openTailGateImmediate'] = 0
				electrics.values['openTailGateDelaySide'] = 0
				electrics.values['openTailGateDelayDown'] = 0				
				openTailGateTimer = 0
			end




			--redundant part, if not present Beam will return an error...
    			if electrics.values['PDa'] == nil then
        			electrics.values['PDa'] = 0
    			end

    			if electrics.values['spinleft'] == nil or electrics.values['spinleft'] <= 0 then
        			electrics.values['spinleft'] = 360
    			end

    			if electrics.values['spinright'] == nil or electrics.values['spinright'] >= 360 then
        			electrics.values['spinright'] = 0
    			end
			--end of redundant part
			

    	electrics.values['PD_R'] = (electrics.values['lightbar']  * ((blinkPDPulseRight * blinkPDModeB) + (blinkPDPulseLeft * blinkPDModeA)))
    	electrics.values['PD_L'] = (electrics.values['lightbar']  * blinkPDPulseLeft)
    	electrics.values['PD_short_R'] = (electrics.values['lightbar']  * blinkPDPulseShortRight)
    	electrics.values['PD_short_L'] = (electrics.values['lightbar']  * blinkPDPulseShortLeft)
		electrics.values['spinright'] = electrics.values['spinright'] +  ((dt * 100) % 360 * electrics.values['lightbar'])
		electrics.values['spinleft'] = electrics.values['spinleft'] -  ((dt * 100) % 360 * electrics.values['lightbar'])
		if v.data.input then
			electrics.values['alley_steer']  = ((((electrics.values['steering']) * (electrics.values['PDa']))/(v.data.input.steeringWheelLock)) - (1-electrics.values['PDa']))
			electrics.values['alley_steerR'] = ((((electrics.values['steering']) * (electrics.values['PDa']))/(v.data.input.steeringWheelLock)) + (1-electrics.values['PDa']))
		end

		electrics.values['cornerLight_L'] = electrics.values['signal_left_input'] * (1-electrics.values['signal_right_input'])
		electrics.values['cornerLight_R'] = electrics.values['signal_right_input'] * (1-electrics.values['signal_left_input'])


end

 


-- public interface
M.Reset       = Reset
M.onInit	= onInit
M.updateGFX   = updateGFX
M.generateBlinkPDTimer = generateBlinkPDTimer

return M