-- Made by Inn0centJok3r
-- (adjusted/partly rewritten by DaddelZeit)

local M = {}

local lastDoorsOpen = false
local lastRoofOpen = false
local lastWindowsOpen = false

local filterCoef = 1
local fullFilterCoef = 1
local filterChanged = false

local windowDamaged = false
local windowBroken = false

local windowRDeformGroup = ""
local windowLDeformGroup = ""
local windowRearDeformGroup = ""

local playerSeated = false
local lastPlayerSeated = false

local ceilingLightTimer = 0
local ceilingLightOverride = nil


local function init(jbeamData)
	windowRDeformGroup = jbeamData.windowRDeformGroup or "doorglass_R_break"
	windowLDeformGroup = jbeamData.windowLDeformGroup or "doorglass_L_break"
	windowRearDeformGroup = jbeamData.windowRearDeformGroup or "tonneauglass"
	playerSeated = false
	lastPlayerSeated = false

	if v.data.sounds then
		fullFilterCoef = v.data.sounds.filterCoef or 1
		filterCoef = fullFilterCoef
	end
end

local function reset()
	windowBroken = false
	windowDamaged = false

	lastDoorsOpen = false
	lastRoofOpen = false
	lastWindowsOpen = false

	playerSeated = false
	lastPlayerSeated = false

	if filterChanged then
		obj:queueGameEngineLua(string.format("core_sounds.cabinFilterStrength = %f", filterCoef))
		filterChanged = false
	end
end

local function setFilter(strength)
	filterChanged = true
	filterCoef = strength
	obj:queueGameEngineLua(string.format("core_sounds.cabinFilterStrength = %f", strength))
end

local function updateGFX(dt)
	playerSeated = playerInfo.anyPlayerSeated
	if playerSeated ~= lastPlayerSeated and playerSeated then
		setFilter(filterCoef)
		lastPlayerSeated = playerSeated
		return
	end


	if windowDamaged and not windowBroken and playerSeated then
		windowBroken = true
		setFilter(0)
	end
	if windowBroken then return end


	local evals = electrics.values

	local doorL = evals["doorLCoupler_notAttached"] or 1
	local doorR = evals["doorRCoupler_notAttached"] or 1
	local doorLWindow = evals["window_left_prop"] or 1
	local doorRWindow = evals["window_right_prop"] or 1
	local doorMissing = not evals["doorLCoupler_notAttached"] or not evals["doorRCoupler_notAttached"] or not evals["window_left_prop"] or not evals["window_right_prop"]

	local roof = evals["roofOpen_notAttached"] or 1
	if evals["roofOpen_notAttached"] == 1 or evals["hardtopF_notAttached"] == 1 or evals["hardtopRR_notAttached"] == 1 or evals["hardtopRL_notAttached"] == 1 then
		roof = 1
	elseif evals["roofOpen_notAttached"] == 0 or evals["hardtopF_notAttached"] == 0 or evals["hardtopRR_notAttached"] == 0 or evals["hardtopRL_notAttached"] == 0 then
		roof = 0
	end

	local roofOpen = roof == 1
	local doorsOpen = doorR == 1 or doorL == 1
	local windowsOpen = doorRWindow ~= 0 or doorLWindow ~= 0
	if roofOpen or doorsOpen or windowsOpen then
		if lastDoorsOpen ~= doorsOpen or lastRoofOpen ~= roofOpen or lastWindowsOpen ~= windowsOpen then
			lastRoofOpen = roofOpen
			lastDoorsOpen = doorsOpen
			lastWindowsOpen = windowsOpen

			if doorsOpen then
				if not doorMissing and evals.ceilingLight then --only change it when ignition is on and no door is missing (otherwise kinda annoying)
					evals.ceilingLight = true
					ceilingLightTimer = evals.ceilingLightTimer or 10
				end
			end

			if playerSeated then
				setFilter(0)
			end
		end
	else
		if lastDoorsOpen or lastRoofOpen or lastWindowsOpen then
			lastRoofOpen = false
			lastDoorsOpen = false
			lastWindowsOpen = false

			if playerSeated then
				setFilter(fullFilterCoef)
			end
		end
	end

	ceilingLightTimer = math.max(ceilingLightTimer - dt, 0)
	evals.ceilingLight = ceilingLightOverride or ceilingLightTimer ~= 0
end

local function beamBroken(id)
    local beam = v.data.beams[id]
    if not beam or not beam.breakGroup then return end

	if beam.breakGroup == windowRDeformGroup or beam.breakGroup == windowLDeformGroup or beam.breakGroup == windowRearDeformGroup then
		windowDamaged = true
	end
end

local function toggleCeilingLightOverride()
	ceilingLightOverride = ceilingLightOverride == nil and true or nil
	electrics.values.ceilingLight = ceilingLightOverride or ceilingLightTimer ~= 0
end

-- public interface
M.init = init
M.reset = reset
M.beamBroken = beamBroken
M.updateGFX = updateGFX
M.toggleCeilingLightOverride = toggleCeilingLightOverride

return M