-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt

local M = {}
M.type = "auxiliary"
M.relevantDevice = nil

local htmlTexture = require("htmlTexture")

local min = math.min
local max = math.max

local gaugesScreenName = nil
local htmlPath = nil
local gaugeHTMLTexture

local updateFPS = 30
local updateTimer = 0
local odoTimer = 0
local setupTimer = 0
local setupcomplete = false

local distanceTotalm = 0
local currenttrip
local tripmeter = {}
local lefthanddrive
local ndoors
local artic
local manualgearbox
local fuelVolume
local fuelConsumption = 0
local previousFuel

local data = {}
local setupdata = {}

local function updateGFX(dt)
    data = {}
	
  updateTimer = updateTimer + dt
  odoTimer = odoTimer + dt
  if updateTimer > (1 / updateFPS) then
    data.dategauge = os.date("%d") .. " " .. string.upper(os.date("%b")) .. " " .. os.date("%Y") .. " " .. os.date("%H") .. ":" .. os.date("%M")
	data.lefthanddrive = lefthanddrive
	data.ndoors = ndoors
	data.artic = artic
	data.manualgearbox = manualgearbox
	
	data.ignitionLevel = electrics.values["ignitionLevel"]
	
	data.kneel = electrics.values["kneel"]
	data.rideheight = electrics.values["rideheight"]
	data.doorLeverF1 = electrics.values["doorLeverF1"]
	data.doorLeverF2 = electrics.values["doorLeverF2"]
	data.doorLeverR1 = electrics.values["doorLeverR1"]
	data.doorLeverR2 = electrics.values["doorLeverR2"]
	data.doorLeverR3 = electrics.values["doorLeverR3"]
	if data.doorLeverF1 > 0 or data.doorLeverF2 > 0 or data.doorLeverR1 > 0 or data.doorLeverR2 > 0 or data.doorLeverR3 > 0 then data.dooropen = 1 else data.dooropen = 0 end
	data.wheelchairrampF = electrics.values["wheelchairrampF"]
	data.wheelchairrampR = electrics.values["wheelchairrampR"]
	data.enginedoor = electrics.values["enginedoor"]
	data.esc = electrics.values["esc"]
	data.tcs = electrics.values["tcs"]
	data.abs = electrics.values["abs"]
	data.gear = electrics.values["gear"]
	data.lowbeam = electrics.values["lowhighbeam"]
	data.highbeam = electrics.values["highbeam"]
	data.parkingbrake = electrics.values["parkingbrake"]
	data.aircon = electrics.values["aircon"]

	distanceTotalm = distanceTotalm + electrics.values.wheelspeed * updateTimer

    --dump(data)
    --htmlTexture.call(gaugesScreenName, "updateData", data)
    gaugeHTMLTexture:streamJS("updateData", "updateData", data)
    updateTimer = 0

	if odoTimer > 0.5 then
		data.gaugeunit = electrics.values["gaugeunit"]

		data.odometer = electrics.values["odometer"]
		currenttrip = electrics.values["currenttrip"]
		data.currenttrip = currenttrip
		tripmeter = {a = electrics.values["tripmetera"], b = electrics.values["tripmeterb"]}
		data.tripmetera = tripmeter["a"]
		data.tripmeterb = tripmeter["b"]
		fuelVolume = electrics.values["fuelVolume"]
		if fuelVolume and previousFuel then
			if fuelVolume > 0 and previousFuel > 0 then
				fuelConsumption = fuelConsumption + previousFuel - fuelVolume
				electrics.values["instfuelConsumption"] = (previousFuel - fuelVolume) / (electrics.values.wheelspeed * odoTimer / 1000) * 100
			end
		end
		if electrics.values.wheelspeed > 0.2 then
			data.instmeter = electrics.values["instfuelConsumption"] or 0
		else
			data.instmeter = -999
		end
		previousFuel = fuelVolume
		if distanceTotalm < 100 then
			data.rangemeter = -999
			data.avgmeter = -999
		else
			if electrics.values.wheelspeed > 0.2 then
				electrics.values["rangemeter"] = fuelVolume / fuelConsumption * (distanceTotalm / 1000)
				electrics.values["avgfuelConsumption"] = fuelConsumption / (distanceTotalm / 1000) * 100
			end
			data.rangemeter = electrics.values["rangemeter"]
			data.avgmeter = electrics.values["avgfuelConsumption"]
		end
		gaugeHTMLTexture:streamJS("updateodo", "updateodo", data)
		odoTimer = 0
	end
  end

  if not setupcomplete then setupTimer = setupTimer + dt end
  if setupTimer > 0.5 and not setupcomplete then
	setupdata = {}
	setupdata.lefthanddrive = lefthanddrive
	setupdata.ndoors = ndoors
	setupdata.artic = artic
	setupdata.manualgearbox = manualgearbox
	setupdata.fueltype = electrics.values["fueltype"]
	gaugeHTMLTexture:callJS("setup", setupdata)
	setupcomplete = true
	setupTimer = 0
  end
end

local function initSecondStage(jbeamData)
	gaugesScreenName = jbeamData.materialName or "@zeekr1hx_gauges_screen_side"
	htmlPath = jbeamData.htmlPath or "local://local/vehicles/zeekr1hx/gauges/zeekr1hx_gauges_side.html"
	local width = jbeamData.textureWidth or 256
	local height = jbeamData.textureHeight or 128
	gaugeHTMLTexture = htmlTexture.new(gaugesScreenName, htmlPath, width, height, updateFPS)
    --htmlTexture.create(gaugesScreenName, htmlPath, width, height, updateFPS, "automatic")
	lefthanddrive = jbeamData.lefthanddrive or 0
	ndoors = jbeamData.ndoors or 4
	manualgearbox = jbeamData.manualgearbox or 0
	artic = electrics.values["artic"]
	previousFuel = 0
	fuelVolume = 0
	currenttrip = electrics.values["currenttrip"] or "a"
	tripmeter = {a = electrics.values["tripmetera"] or 0, b = electrics.values["tripmeterb"] or 0}

	--gaugeHTMLTexture:callJS("setup", data)
    --htmlTexture.call(gaugesScreenName, "initsidegauge", data)
	setupcomplete = false
end

M.init = nop
M.initSecondStage = initSecondStage
M.updateGFX = updateGFX

return M
