-- written by DaddelZeit
-- DO NOT USE WITHOUT PERMISSION
-- this also goes for "vehicles/sbr/sbr_parts/sbr_gt6facelift/gauge_display/sunburst_facelift_display.html"

local M = {}
M.type = "auxiliary"
M.relevantDevice = nil

local htmlTexture = require("htmlTexture")

local gaugesScreenName = nil
local htmlPath = nil

local updateTimer = 0
local updateFPS = 30

local includeMap = false
local gpsData = {x = 0, y = 0, rotation = 0, zoom = 1}

local function updateGFX(dt)
  updateTimer = updateTimer + dt

  if playerInfo.anyPlayerSeated and obj:getUpdateUIflag() then
    local data = {}
    if zeitRadio then data = zeitRadio.getCurrentlyPlayingSongData() end
    data.running = electrics.values.running or false
    htmlTexture.call(gaugesScreenName, "updateData", data)

    if includeMap then
      updateTimer = 0
      local pos = obj:getPosition()
      local rotation = math.deg(obj:getDirection()) + 180
      local speed = electrics.values.airspeed * 3.6
      local zoom = math.min(150 + speed * 1.5, 250)

      gpsData.x = pos.x
      gpsData.y = pos.y
      gpsData.rotation = rotation
      gpsData.zoom = zoom
      htmlTexture.call(gaugesScreenName, "map.updateData", gpsData)
    end

    updateTimer = 0
  end
end

local function reset()
end

local function init(jbeamData)
  gaugesScreenName = jbeamData.gaugesScreenName
  htmlPath = jbeamData.htmlPath
  local width = jbeamData.width or 256
  local height = jbeamData.height or 256

  includeMap = jbeamData.includeMap or false

  if not gaugesScreenName then
    log("E", "sbrGaugeScreen", "Got no material name for the texture, can't display anything...")
    M.updateGFX = nop
  else
    if htmlPath then
      htmlTexture.create(gaugesScreenName, htmlPath, width, height, updateFPS, "automatic")
      if includeMap then
        obj:queueGameEngineLua(string.format("extensions.ui_uinavi.requestVehicleDashboardMap(%q)", gaugesScreenName))
      end
    else
      log("E", "sbrGaugeScreen", "Got no html path for the texture, can't display anything...")
      M.updateGFX = nop
    end
  end
end

M.reset = reset
M.init = init
M.updateGFX = updateGFX

return M
