-- written by DaddelZeit
-- DO NOT USE ANY PART OF THIS CODE WITHOUT EXPLICIT PERMISSION

local M = {}

local lastValue = 0
local value = 0
local lightUpdatedTimer = -1
local manuallyTurnedOff = false

local function updateAutoHeadlights(val)
    if manuallyTurnedOff then return end
    value = val

    if (lastValue == 2 and value == 1) then
        lightUpdatedTimer = 7
    end

    if (value == 2 and lightUpdatedTimer == -1) or (value < 2) then
        electrics.setLightsState(value)
        lastValue = value
    end
end

local function updateGFX(dt)
    if lightUpdatedTimer > -1 then
        lightUpdatedTimer=lightUpdatedTimer-dt
        if lightUpdatedTimer <= 0 then
            lightUpdatedTimer = -1
            if electrics.values.lowhighbeam == 1 then
                updateAutoHeadlights(value)
            end
        end
    end

    if electrics.values.lowhighbeam == 0 and lastValue ~= 0 then
        manuallyTurnedOff = true
    elseif manuallyTurnedOff and electrics.values.lowhighbeam == 1 then
        manuallyTurnedOff = false
    end
end

local function onReset()
    manuallyTurnedOff = false
    lastValue = 0
end

local function onExtensionLoaded()
    obj:queueGameEngineLua("if not autoHeadlightsZeit then extensions.load('autoHeadlightsZeit') end ")
    obj:queueGameEngineLua("if autoHeadlightsZeit then autoHeadlightsZeit.registerVeh("..obj:getId()..") end") -- register the car
    manuallyTurnedOff = false
end

M.onReset = onReset
M.updateGFX = updateGFX
M.onExtensionLoaded = onExtensionLoaded
M.updateAutoHeadlights = updateAutoHeadlights

return M