angular.module('airSuspension', [])
.controller('AirSuspensionController', function($scope, $window) {
  const MIN_PSI = 40;
  const MAX_PSI = 110;

  // Initialize values
  $scope.airbagFL = 0;
  $scope.airbagFR = 0;
  $scope.airbagRL = 0;
  $scope.airbagRR = 0;
  $scope.tankPsi = 0;

  $window.updateData = function(data) {
    $scope.$evalAsync(function() {
      if (data && data.electrics) {
        // Convert airbag values from 0-1 range to PSI
        $scope.airbagFL = Math.round((data.electrics.airbag_fl * (MAX_PSI - MIN_PSI)) + MIN_PSI) || MIN_PSI;
        $scope.airbagFR = Math.round((data.electrics.airbag_fr * (MAX_PSI - MIN_PSI)) + MIN_PSI) || MIN_PSI;
        $scope.airbagRL = Math.round((data.electrics.airbag_rl * (MAX_PSI - MIN_PSI)) + MIN_PSI) || MIN_PSI;
        $scope.airbagRR = Math.round((data.electrics.airbag_rr * (MAX_PSI - MIN_PSI)) + MIN_PSI) || MIN_PSI;
        
        // Get tank PSI directly from electrics with safer handling
        $scope.tankPsi = data.electrics.tankPsi ? parseFloat(data.electrics.tankPsi.toFixed(1)) : 185;
      }
    });
  };
});