local M = {}

local soundManager = require('baggedSuspension/soundManager')
local tankManager = require('baggedSuspension/tankManager')
local positionManager = require('baggedSuspension/positionManager')

local function updateGFX(dt)
    if not electrics or electrics.values.air_system_enabled ~= 1 then return end
    
    positionManager.update(dt, tankManager.getMaxPosition(), tankManager.getFillRateModifier())
    tankManager.updateTankPressure(positionManager.getPositions())
end

local function onReset()
    if electrics and electrics.values.air_system_enabled == 1 then
        positionManager.reset()
        tankManager.reset()
        soundManager.reset()
    end
end

local function onExtensionLoaded()
end

local function onVehicleActiveChanged(active)
    if active then
        electrics.registerHandler("updateGFX", updateGFX)
        onReset()
    else
        soundManager.stopAllSounds()
    end
end

local function destroy()
    soundManager.destroy()
end

M.onVehicleActiveChanged = onVehicleActiveChanged
M.onReset = onReset
M.updateGFX = updateGFX
M.onExtensionLoaded = onExtensionLoaded
M.destroy = destroy

return M