local M = {}
M.type = "auxiliary"
local htmlTexture = require("htmlTexture")

local screenMaterialName = nil
local htmlFilePath = nil
local textureWidth = 1024
local textureHeight = 1024
local textureFPS = 60
local updateTimer = 0
local invFPS = 1 / 60
local lastSentData = nil
local htmlInitialized = false

local function areTablesEqual(t1, t2)
    if type(t1) ~= "table" or type(t2) ~= "table" then return false end
    for k, v in pairs(t1) do
        if t2[k] ~= v then return false end
    end
    for k, v in pairs(t2) do
        if t1[k] ~= v then return false end
    end
    return true
end

local function updateGFX(dt)
    if not screenMaterialName then return end

    updateTimer = updateTimer + dt
    if updateTimer > invFPS then
        updateTimer = 0

        local electricsData = {
            electrics = {
                lowhighbeam = electrics.values.lowhighbeam or 0,
                brakelights = electrics.values.brake_input or 0,
                signal_R = electrics.values.signal_R or 0,
                signal_L = electrics.values.signal_L or 0,
                reverse = electrics.values.reverse or 0,
                scrollSpeed = electrics.values.scrollSpeed or 60,
                mirrorMode = electrics.values.mirrorMode or false,
                rainbowMode = electrics.values.rainbowMode or false,
                rainbowSpeed = electrics.values.rainbowSpeed or 0.5,
                staticMode = electrics.values.staticMode or false,
                textPosition = electrics.values.textPosition or 0,
                taillightTextLength = electrics.values.taillightTextLength or 0,
                taillightText1 = electrics.values.taillightText1 or "0,0,0,0,0",
                taillightText2 = electrics.values.taillightText2 or "0,0,0,0,0",
                taillightText3 = electrics.values.taillightText3 or "0,0,0,0,0",
                taillightText4 = electrics.values.taillightText4 or "0,0,0,0,0",
                taillightText5 = electrics.values.taillightText5 or "0,0,0,0,0",
                taillightText6 = electrics.values.taillightText6 or "0,0,0,0,0",
                taillightFontSize = electrics.values.taillightFontSize or 15,
                textRed = electrics.values.textRed or 255,
                textGreen = electrics.values.textGreen or 0,
                textBlue = electrics.values.textBlue or 0
            }
        }

        if not lastSentData or not areTablesEqual(lastSentData, electricsData.electrics) then
            htmlTexture.call(screenMaterialName, "updateData", electricsData)
            lastSentData = electricsData.electrics
            if electricsData.electrics.brakelights ~= 0 then
                log('I', 'taillight', 'Brake signal sent: ' .. tostring(electricsData.electrics.brakelights))
            end
        end
    end
end

local function init(jbeamData)
    if not jbeamData then return end

    screenMaterialName = jbeamData.screenMaterialName
    htmlFilePath = jbeamData.htmlFilePath
    textureWidth = jbeamData.textureWidth or textureWidth
    textureHeight = jbeamData.textureHeight or textureHeight
    textureFPS = jbeamData.textureFPS or textureFPS

    if not screenMaterialName or not htmlFilePath then return end

    if not htmlInitialized then
        htmlTexture.create(screenMaterialName, htmlFilePath, textureWidth, textureHeight, textureFPS, "automatic")
        htmlInitialized = true
    end
end

local function onReset()
    updateTimer = 0
end

M.onReset = onReset
M.init = init
M.updateGFX = updateGFX

return M