local M = {}

function M.updateGFX(dt)
    if electrics.values.ignitionLevel == 0 then
        for i = 1, 4 do
            for _, seg in ipairs({'A','B','C','D','E','F','G'}) do
                electrics.values["RLA_Supra_d" .. i .. "_seg" .. seg] = 0
            end
        end
        return
    end
    
    local timeTable = os.date("*t")
    local hours = timeTable.hour
    local minutes = timeTable.min
    
    -- Convert to 12 hour format
    if hours > 12 then
        hours = hours - 12
    elseif hours == 0 then
        hours = 12
    end
    
    local hourTens = 0
    local hourOnes = hours
    
    if hours >= 10 then
        hourTens = math.floor(hours / 10)
        hourOnes = hours % 10
    end
    
    local minuteTens = math.floor(minutes / 10)
    local minuteOnes = minutes % 10

    -- Define digit patterns
    local digitPatterns = {
        [0] = {1,1,1,1,1,1,0},  -- 0
        [1] = {0,1,1,0,0,0,0},  -- 1
        [2] = {1,1,0,1,1,0,1},  -- 2
        [3] = {1,1,1,1,0,0,1},  -- 3
        [4] = {0,1,1,0,0,1,1},  -- 4
        [5] = {1,0,1,1,0,1,1},  -- 5
        [6] = {1,0,1,1,1,1,1},  -- 6
        [7] = {1,1,1,0,0,0,0},  -- 7
        [8] = {1,1,1,1,1,1,1},  -- 8
        [9] = {1,1,1,1,0,1,1}   -- 9
    }

    local function setDigit(digitNum, value, visible)
        if not visible then
            electrics.values["RLA_Supra_d" .. digitNum .. "_segA"] = 0
            electrics.values["RLA_Supra_d" .. digitNum .. "_segB"] = 0
            electrics.values["RLA_Supra_d" .. digitNum .. "_segC"] = 0
            electrics.values["RLA_Supra_d" .. digitNum .. "_segD"] = 0
            electrics.values["RLA_Supra_d" .. digitNum .. "_segE"] = 0
            electrics.values["RLA_Supra_d" .. digitNum .. "_segF"] = 0
            electrics.values["RLA_Supra_d" .. digitNum .. "_segG"] = 0
            return
        end

        local pattern = digitPatterns[value]
        if pattern then
            electrics.values["RLA_Supra_d" .. digitNum .. "_segA"] = pattern[1]
            electrics.values["RLA_Supra_d" .. digitNum .. "_segB"] = pattern[2]
            electrics.values["RLA_Supra_d" .. digitNum .. "_segC"] = pattern[3]
            electrics.values["RLA_Supra_d" .. digitNum .. "_segD"] = pattern[4]
            electrics.values["RLA_Supra_d" .. digitNum .. "_segE"] = pattern[5]
            electrics.values["RLA_Supra_d" .. digitNum .. "_segF"] = pattern[6]
            electrics.values["RLA_Supra_d" .. digitNum .. "_segG"] = pattern[7]
        end
    end

    setDigit(1, hourTens, hours >= 10)
    setDigit(2, hourOnes, true)
    setDigit(3, minuteTens, true)
    setDigit(4, minuteOnes, true)
end

return M