local M = {}

local LED_COUNT = 143
local SIGNAL_LED_COUNT = 134
local REVERSE_LED_COUNT = 30
local DELAY_BETWEEN_LEDS = 0.005
local SIGNAL_DELAY = 0.002
local REVERSE_DELAY = 0.004
local BRAKE_LEDS_PER_STEP = 10
local SIGNAL_LEDS_PER_STEP = 20
local REVERSE_LEDS_PER_STEP = 5

local sequenceState = "off"
local tailLightState = "off"
local signalRState = "off"
local signalLState = "off"
local reverseState = "off"

local currentLed = 0
local currentTailLed = 0
local currentSignalRLed = 0
local currentSignalLLed = 0
local currentReverseLed = 0

local sequenceTimer = 0
local tailSequenceTimer = 0
local signalRTimer = 0
local signalLTimer = 0
local reverseTimer = 0

local previousBrakeState = 0
local previousLightState = 0
local previousSignalRState = 0
local previousSignalLState = 0
local previousReverseState = 0

M.init = function(jbeamData)
    sequenceState = "off"
    tailLightState = "off"
    signalRState = "off"
    signalLState = "off"
    reverseState = "off"
    
    M.reset()
    
    return true
end

M.updateGFX = function(dt)
    local brakeValue = electrics.values.brake or 0
    local lightValue = electrics.values.lowhighbeam or 0
    local signalRValue = electrics.values.signal_R or 0
    local signalLValue = electrics.values.signal_L or 0
    local reverseValue = electrics.values.reverse or 0
    
    if brakeValue > 0 and previousBrakeState <= 0 then
        sequenceState = "turning_on"
        currentLed = 0
        sequenceTimer = 0
    elseif brakeValue <= 0 and previousBrakeState > 0 then
        sequenceState = "turning_off"
        currentLed = 0
        sequenceTimer = 0
    end
    
    if lightValue > 0 and previousLightState <= 0 then
        tailLightState = "turning_on"
        currentTailLed = 0
        tailSequenceTimer = 0
    elseif lightValue <= 0 and previousLightState > 0 then
        tailLightState = "turning_off"
        currentTailLed = 0
        tailSequenceTimer = 0
    end
    
    if signalRValue > 0 and previousSignalRState <= 0 then
        signalRState = "turning_on"
        currentSignalRLed = 0
        signalRTimer = 0
    elseif signalRValue <= 0 and previousSignalRState > 0 then
        signalRState = "off"
        for i = 1, SIGNAL_LED_COUNT do
            if electrics then
                electrics.values["RLA_Supra_LED_signal_R_" .. i] = 0
            end
        end
    end
    
    if signalLValue > 0 and previousSignalLState <= 0 then
        signalLState = "turning_on"
        currentSignalLLed = 0
        signalLTimer = 0
    elseif signalLValue <= 0 and previousSignalLState > 0 then
        signalLState = "off"
        for i = 1, SIGNAL_LED_COUNT do
            if electrics then
                electrics.values["RLA_Supra_LED_signal_L_" .. i] = 0
            end
        end
    end
    
    if reverseValue > 0 and previousReverseState <= 0 then
        reverseState = "turning_on"
        currentReverseLed = 0
        reverseTimer = 0
    elseif reverseValue <= 0 and previousReverseState > 0 then
        reverseState = "turning_off"
        currentReverseLed = 0
        reverseTimer = 0
    end
    
    if sequenceState == "turning_on" then
        sequenceTimer = sequenceTimer + dt
        if sequenceTimer >= DELAY_BETWEEN_LEDS and currentLed < LED_COUNT then
            for i = 1, BRAKE_LEDS_PER_STEP do
                currentLed = currentLed + 1
                if currentLed <= LED_COUNT then
                    if electrics then
                        electrics.values["RLA_Supra_LED_brake_" .. currentLed] = 1
                    end
                end
                if currentLed >= LED_COUNT then
                    sequenceState = "on"
                    break
                end
            end
            sequenceTimer = 0
        end
    elseif sequenceState == "turning_off" then
        sequenceTimer = sequenceTimer + dt
        if sequenceTimer >= DELAY_BETWEEN_LEDS and currentLed < LED_COUNT then
            for i = 1, BRAKE_LEDS_PER_STEP do
                currentLed = currentLed + 1
                local ledToTurnOff = LED_COUNT - currentLed + 1
                if ledToTurnOff >= 1 then
                    if electrics then
                        electrics.values["RLA_Supra_LED_brake_" .. ledToTurnOff] = 0
                    end
                end
                if currentLed >= LED_COUNT then
                    sequenceState = "off"
                    break
                end
            end
            sequenceTimer = 0
        end
    end
    
    if tailLightState == "turning_on" then
        tailSequenceTimer = tailSequenceTimer + dt
        if tailSequenceTimer >= DELAY_BETWEEN_LEDS and currentTailLed < LED_COUNT then
            for i = 1, BRAKE_LEDS_PER_STEP do
                currentTailLed = currentTailLed + 1
                if currentTailLed <= LED_COUNT then
                    if electrics then
                        electrics.values["RLA_Supra_LED_tail_" .. currentTailLed] = 1
                    end
                end
                if currentTailLed >= LED_COUNT then
                    tailLightState = "on"
                    break
                end
            end
            tailSequenceTimer = 0
        end
    elseif tailLightState == "turning_off" then
        tailSequenceTimer = tailSequenceTimer + dt
        if tailSequenceTimer >= DELAY_BETWEEN_LEDS and currentTailLed < LED_COUNT then
            for i = 1, BRAKE_LEDS_PER_STEP do
                currentTailLed = currentTailLed + 1
                local ledToTurnOff = LED_COUNT - currentTailLed + 1
                if ledToTurnOff >= 1 then
                    if electrics then
                        electrics.values["RLA_Supra_LED_tail_" .. ledToTurnOff] = 0
                    end
                end
                if currentTailLed >= LED_COUNT then
                    tailLightState = "off"
                    break
                end
            end
            tailSequenceTimer = 0
        end
    end
    
    if signalRState == "turning_on" then
        signalRTimer = signalRTimer + dt
        if signalRTimer >= SIGNAL_DELAY and currentSignalRLed < SIGNAL_LED_COUNT then
            for i = 1, SIGNAL_LEDS_PER_STEP do
                currentSignalRLed = currentSignalRLed + 1
                if currentSignalRLed <= SIGNAL_LED_COUNT then
                    if electrics then
                        electrics.values["RLA_Supra_LED_signal_R_" .. currentSignalRLed] = 1
                    end
                end
                if currentSignalRLed >= SIGNAL_LED_COUNT then
                    signalRState = "on"
                    break
                end
            end
            signalRTimer = 0
        end
    end
    
    if signalLState == "turning_on" then
        signalLTimer = signalLTimer + dt
        if signalLTimer >= SIGNAL_DELAY and currentSignalLLed < SIGNAL_LED_COUNT then
            for i = 1, SIGNAL_LEDS_PER_STEP do
                currentSignalLLed = currentSignalLLed + 1
                if currentSignalLLed <= SIGNAL_LED_COUNT then
                    if electrics then
                        electrics.values["RLA_Supra_LED_signal_L_" .. currentSignalLLed] = 1
                    end
                end
                if currentSignalLLed >= SIGNAL_LED_COUNT then
                    signalLState = "on"
                    break
                end
            end
            signalLTimer = 0
        end
    end
    
    if reverseState == "turning_on" then
        reverseTimer = reverseTimer + dt
        if reverseTimer >= REVERSE_DELAY and currentReverseLed < REVERSE_LED_COUNT then
            for i = 1, REVERSE_LEDS_PER_STEP do
                currentReverseLed = currentReverseLed + 1
                if currentReverseLed <= REVERSE_LED_COUNT then
                    if electrics then
                        electrics.values["RLA_Supra_LED_reverse_" .. currentReverseLed] = 1
                    end
                end
                if currentReverseLed >= REVERSE_LED_COUNT then
                    reverseState = "on"
                    break
                end
            end
            reverseTimer = 0
        end
    elseif reverseState == "turning_off" then
        reverseTimer = reverseTimer + dt
        if reverseTimer >= REVERSE_DELAY and currentReverseLed < REVERSE_LED_COUNT then
            for i = 1, REVERSE_LEDS_PER_STEP do
                currentReverseLed = currentReverseLed + 1
                local ledToTurnOff = REVERSE_LED_COUNT - currentReverseLed + 1
                if ledToTurnOff >= 1 then
                    if electrics then
                        electrics.values["RLA_Supra_LED_reverse_" .. ledToTurnOff] = 0
                    end
                end
                if currentReverseLed >= REVERSE_LED_COUNT then
                    reverseState = "off"
                    break
                end
            end
            reverseTimer = 0
        end
    end
    
    previousBrakeState = brakeValue
    previousLightState = lightValue
    previousSignalRState = signalRValue
    previousSignalLState = signalLValue
    previousReverseState = reverseValue
end

M.reset = function()
    sequenceState = "off"
    tailLightState = "off"
    signalRState = "off"
    signalLState = "off"
    reverseState = "off"
    
    currentLed = 0
    currentTailLed = 0
    currentSignalRLed = 0
    currentSignalLLed = 0
    currentReverseLed = 0
    
    sequenceTimer = 0
    tailSequenceTimer = 0
    signalRTimer = 0
    signalLTimer = 0
    reverseTimer = 0
    
    previousBrakeState = 0
    previousLightState = 0
    previousSignalRState = 0
    previousSignalLState = 0
    previousReverseState = 0
    
    for i = 1, LED_COUNT do
        if electrics then
            if i <= LED_COUNT then
                electrics.values["RLA_Supra_LED_brake_" .. i] = 0
                electrics.values["RLA_Supra_LED_tail_" .. i] = 0
            end
            if i <= SIGNAL_LED_COUNT then
                electrics.values["RLA_Supra_LED_signal_R_" .. i] = 0
                electrics.values["RLA_Supra_LED_signal_L_" .. i] = 0
            end
            if i <= REVERSE_LED_COUNT then
                electrics.values["RLA_Supra_LED_reverse_" .. i] = 0
            end
        end
    end
end

return M