local M = {}

function M.init(id)
end

function M.updateGFX(dt)
    if electrics.values.ignitionLevel == 0 then
        for _, seg in ipairs({'A','B','C','D','E','F','G'}) do
            electrics.values["RLA_Supra_sq_seg" .. seg] = 0
        end
        return
    end
    
    local gear = electrics.values.gear_M
    
    local displayValue
    if gear == nil or gear == 0 then
        displayValue = 0
    elseif gear == -1 then
        displayValue = 'R'
    else
        displayValue = math.abs(gear)
    end
    
    local patterns = {
        [0] = {0,0,1,0,1,0,1},  -- 0 (Neutral)
        [1] = {0,1,1,0,0,0,0},  -- 1
        [2] = {1,1,0,1,1,0,1},  -- 2
        [3] = {1,1,1,1,0,0,1},  -- 3
        [4] = {0,1,1,0,0,1,1},  -- 4
        [5] = {1,0,1,1,0,1,1},  -- 5
        [6] = {1,0,1,1,1,1,1},  -- 6
        ['R'] = {1,1,1,0,1,1,1}   -- R
    }
    
    local pattern = patterns[displayValue]
    if pattern then
        electrics.values["RLA_Supra_sq_segA"] = pattern[1]
        electrics.values["RLA_Supra_sq_segB"] = pattern[2]
        electrics.values["RLA_Supra_sq_segC"] = pattern[3]
        electrics.values["RLA_Supra_sq_segD"] = pattern[4]
        electrics.values["RLA_Supra_sq_segE"] = pattern[5]
        electrics.values["RLA_Supra_sq_segF"] = pattern[6]
        electrics.values["RLA_Supra_sq_segG"] = pattern[7]
    else
        for _, seg in ipairs({'A','B','C','D','E','F','G'}) do
            electrics.values["RLA_Supra_sq_seg" .. seg] = 0
        end
    end
end

return M