local M = {}

M.updateGFX = function(dt)
    local leftDoorState = electrics.values.doorLCoupler_notAttached
    local rightDoorState = electrics.values.doorRCoupler_notAttached
    local leftTrigger = electrics.values.doorControlL or 0
    local rightTrigger = electrics.values.doorControlR or 0

    local anyDoorOpen = (leftDoorState == 1 or rightDoorState == 1)

    if leftTrigger > 0 then
        electrics.values.rla_door_light_L = 1
    else
        electrics.values.rla_door_light_L = anyDoorOpen and 1 or 0
    end

    if rightTrigger > 0 then
        electrics.values.rla_door_light_R = 1
    else
        electrics.values.rla_door_light_R = anyDoorOpen and 1 or 0
    end
end

return M