local M = {}

local currentState = 1

local function updateValveSprings(dt)
    if electrics.values.engineRunning then
        local rpmspin = electrics.values.rpmspin or 0
        currentState = math.floor((rpmspin / 100) % 3) + 1
    end
    
    if currentState == 1 then
        electrics.values.RLA_Supra_2jz_springs_a = 1
        electrics.values.RLA_Supra_2jz_springs_b = 0
        electrics.values.RLA_Supra_2jz_springs_c = 0
    elseif currentState == 2 then
        electrics.values.RLA_Supra_2jz_springs_a = 0
        electrics.values.RLA_Supra_2jz_springs_b = 1
        electrics.values.RLA_Supra_2jz_springs_c = 0
    else
        electrics.values.RLA_Supra_2jz_springs_a = 0
        electrics.values.RLA_Supra_2jz_springs_b = 0
        electrics.values.RLA_Supra_2jz_springs_c = 1
    end
end

local function onInit()
    currentState = 1
    electrics.values.RLA_Supra_2jz_springs_a = 1
    electrics.values.RLA_Supra_2jz_springs_b = 0
    electrics.values.RLA_Supra_2jz_springs_c = 0
end

M.onInit = onInit
M.updateGFX = updateValveSprings

return M