local M = {}
local NUM_CYLINDERS = 6
local NUM_FRAMES = 16
local SPEED_MULTIPLIER = 6  
local rpmState = 0
local sixteenth = 1/16
local cylinderOffsets = {
    -10,      -- Cylinder 1
    230,    -- Cylinder 2
    110,    -- Cylinder 3
    110,    -- Cylinder 4
    230,    -- Cylinder 5
    -10       -- Cylinder 6
}
local function updateGFX(dt)
    rpmState = (rpmState + dt * electrics.values.rpm * SPEED_MULTIPLIER) % 360
    for i = 1, NUM_CYLINDERS do
        local cylinderState = (rpmState + cylinderOffsets[i]) % 360
        electrics.values["cylinder" .. i] = math.abs(cylinderState - 180)/180
        electrics.values["combustionStroke" .. i] = cylinderState > 180
    end
    for i = 1, NUM_FRAMES do
        electrics.values["connectingRods"..i] = false
    end
    local animFrame = math.floor(rpmState/360/sixteenth)+1
    electrics.values["connectingRods"..animFrame] = true
end
function M.setCylinderOffset(cylinderIndex, offsetDegrees)
    if cylinderIndex >= 1 and cylinderIndex <= NUM_CYLINDERS then
        cylinderOffsets[cylinderIndex] = offsetDegrees % 360
    end
end
function M.getCylinderOffset(cylinderIndex)
    if cylinderIndex >= 1 and cylinderIndex <= NUM_CYLINDERS then
        return cylinderOffsets[cylinderIndex]
    end
    return nil
end
function M.setSpeed(multiplier)
    SPEED_MULTIPLIER = multiplier
end
function M.getSpeed()
    return SPEED_MULTIPLIER
end
M.updateGFX = updateGFX
return M