local M = {}
M.type = "auxiliary"

local htmlTexture = require("htmlTexture")

local screenMaterialName = nil
local htmlFilePath = nil
local textureWidth = 0
local textureHeight = 0
local textureFPS = 0
local updateTimer = 0
local invFPS = 1 / 30

local function updateGFX(dt)
  updateTimer = updateTimer + dt
  if updateTimer > invFPS then
    updateTimer = 0
  end
end

local function init(jbeamData)
  screenMaterialName = jbeamData.screenMaterialName
  htmlFilePath = jbeamData.htmlFilePath
  textureWidth = jbeamData.textureWidth
  textureHeight = jbeamData.textureHeight
  textureFPS = jbeamData.textureFPS

  htmlTexture.create(screenMaterialName, htmlFilePath, textureWidth, textureHeight, textureFPS, "automatic")
end

M.init = init
M.reset = nop
M.updateGFX = updateGFX

return M
