local M = {}

local currentPressure = 0
local pressureDecayTimer = 0

local function lerp(a, b, t)
    return a + (b - a) * t
end

local function calculateFuelPressure(rpm, throttle, engineLoad)
    -- Base pressure when engine is running (idle pressure)
    local basePressure = 30
    
    local rpmFactor = math.min(rpm / 8000, 1)
    local rpmPressure = rpmFactor * 20
    
    local loadPressure = engineLoad * 25
    
    local throttlePressure = throttle * 15
    
    local finalPressure = basePressure + rpmPressure + loadPressure + throttlePressure
    
    finalPressure = math.max(0, math.min(90, finalPressure))
    
    finalPressure = finalPressure + (math.random() - 0.5) * 0.5
    
    return finalPressure
end

function M.updateGFX(dt)
    local rpm = electrics.values.rpm or 0
    local throttle = electrics.values.throttle or 0
    local engineLoad = electrics.values.engineLoad or 0
    
    local targetPressure = calculateFuelPressure(rpm, throttle, engineLoad)
    
    if rpm < 100 then
        pressureDecayTimer = pressureDecayTimer + dt
        local decayFactor = math.max(0, 1 - (pressureDecayTimer / 0.75))
        targetPressure = currentPressure * decayFactor
    else
        pressureDecayTimer = 0
    end
    
    local smoothingFactor = targetPressure > currentPressure and 0.05 or 0.02
    currentPressure = lerp(currentPressure, targetPressure, math.min(1, dt * (1 / smoothingFactor)))
    
    electrics.values.fuel_pressure = currentPressure
end

return M