local M = {}
local function s()
   local state = {
       doorLHandleAllowed = true,
       doorRHandleAllowed = true,
       handleLTimer = 0,
       handleRTimer = 0,
       handleInterval = 0.4
   }

   local function resetElectrics()
       electrics.values.doorHandleElectricL = 0
       electrics.values.doorHandleElectricR = 0
       electrics.values.RLA_Supra_door_handle_L = 0
       electrics.values.RLA_Supra_door_handle_R = 0
   end

   local function updateDoorHandle(dt)
       -- Left door handle
       if electrics.values.doorLCoupler_notAttached == 1 and state.doorLHandleAllowed == true then
           if electrics.values.RLA_Supra_door_handle_L == 1 then
               electrics.values.doorHandleElectricL = 1
               state.handleLTimer = state.handleLTimer + dt
               
               if state.handleLTimer >= state.handleInterval then
                   electrics.values.doorHandleElectricL = 0
                   state.doorLHandleAllowed = false
               end
           end
       end
       
       if electrics.values.doorLCoupler_notAttached == 0 and state.doorLHandleAllowed == false then
           state.doorLHandleAllowed = true
           state.handleLTimer = 0
       end

       -- Right door handle
       if electrics.values.doorRCoupler_notAttached == 1 and state.doorRHandleAllowed == true then
           if electrics.values.RLA_Supra_door_handle_R == 1 then
               electrics.values.doorHandleElectricR = 1
               state.handleRTimer = state.handleRTimer + dt
               
               if state.handleRTimer >= state.handleInterval then
                   electrics.values.doorHandleElectricR = 0
                   state.doorRHandleAllowed = false
               end
           end
       end
       
       if electrics.values.doorRCoupler_notAttached == 0 and state.doorRHandleAllowed == false then
           state.doorRHandleAllowed = true
           state.handleRTimer = 0
       end
   end

   local function reset()
       state.doorLHandleAllowed = true
       state.doorRHandleAllowed = true
       state.handleLTimer = 0
       state.handleRTimer = 0
       resetElectrics()
   end

   local function init()
       resetElectrics()
   end

   return {
       update = updateDoorHandle,
       reset = reset,
       init = init
   }
end

local controller = s()
M.updateGFX = controller.update
M.onReset = controller.reset
M.onInit = controller.init
return M