angular.module('gaugesScreen', [])

  .controller('GaugesScreenController', ($scope, $element, $window) => {
    "use strict";

    const degToRad = deg => (deg * Math.PI) / 180.0;
    const radToDeg = rad => (rad * 180.0) / Math.PI;
    const KMH_TO_MPH = 0.621371;

    let initData;
    let status = {
      svg: false,
      setup: false,
      init: false
    };

    let svg;
    let defs;
    let lineGradientPrimary;
    let lineGradientSecondary;
    let lineGradientRed;
    let arcGradient;
    let speedoNeedle;
    let tachoNeedle;
    let fuelLevel;
    let tempLevel;
    let tempTextLow;
    let tempTextMid;
    let tempTextHigh;
    let tempTextUnit;

    let warnings = {};

    let speedText;
    let speedUnitText;
    let gearText;
    let speedoUnitText;
    let tachoUnitText;
    let envTempText;
    let clockText;
    let consSuffix = 'l/100km';
    let odoText;
    let tripText;
    let rangeText;
    let distSuffix = 'km';
    let modeText;
    let startline;

    const gaugeAngleDeg = 225;
    const gaugeRadius = 143.75;

    const speedoStartAngleDeg = 225;
    const tachoStartAngleDeg = 180;

    let smoothedRpmAmt = 0;
    
    $scope.onSVGLoaded = () => {
      svg = $element[0].children[0].children[0];
      defs = hu('#defs1', svg);
      lineGradientPrimary = hu('<linearGradient>', defs).attr({id:'lineGradientPrimary'});
      lineGradientPrimary.stops(
        {offset:0, stopColor:'white', stopOpacity:1},
        {offset:1, stopColor:'white', stopOpacity:0}
      );
      lineGradientSecondary = hu('<linearGradient>', defs).attr({id:'lineGradientSecondary'});
      lineGradientSecondary.stops(
        {offset:0, stopColor:'white', stopOpacity:0.25},
        {offset:1, stopColor:'white', stopOpacity:0}
      );
      lineGradientRed = hu('<linearGradient>', defs).attr({id:'lineGradientRed'});
      lineGradientRed.stops(
        {offset:0, stopColor:'white', stopOpacity:1},
        {offset:0.1, stopColor:'red', stopOpacity:1},
        {offset:1, stopColor: 'red', stopOpacity:0}
      );
      arcGradient = hu('<radialGradient>', defs).attr({
        id: 'arcGradient', cx:0, cy:0, r: 3
      });
      arcGradient.stops(
        {offset:0, stopColor:'black', stopOpacity:1},
        {offset:0.5, stopColor:'red', stopOpacity:1}
      );
      speedoNeedle = hu('#speedoNeedle', svg);
      tachoNeedle = hu('#tachoNeedle', svg);
      fuelLevel = hu('#fuelLevel', svg);
      tempLevel = hu('#tempLevel', svg);

      warnings.signal_L = hu('#signal_L', svg);
      warnings.signal_R = hu('#signal_R', svg);
      warnings.hazard = hu('#hazard', svg);
      warnings.esc = hu('#esc', svg).css({
        fontFamily: 'Goldman-Regular'
      });;
      warnings.tcs = hu('#tcs', svg).css({
        fontFamily: 'Goldman-Regular'
      });;
      warnings.battery = hu('#battery', svg);
      warnings.oil = hu('#oil', svg);
      warnings.checkengine = hu('#checkengine', svg);
      warnings.parkbrake = hu('#parkbrake', svg);
      warnings.lowfuel = hu('#lowfuel', svg);
      warnings.lowpressure = hu('#lowpressure', svg);
      warnings.lowbeam = hu('#lowbeam', svg);
      warnings.highbeam = hu('#highbeam', svg);
      warnings.foglight = hu('#foglight', svg);
      warnings.rearfog = hu('#rearfog', svg);
      warnings.abs = hu('#abs', svg);

      speedText = hu('#speedText', svg).css({  
        fontFamily: 'Goldman-Regular'
      });
      speedUnitText = hu('#speedUnitText', svg).css({
        fontFamily: 'Goldman-Regular'
      });
      gearText = hu('#gearText', svg).css({
        fontFamily: 'Goldman-Regular'
      });
      speedoUnitText = hu('#speedoUnitText', svg).css({
        fontFamily: 'Goldman-Regular'
      });
      tachoUnitText = hu('#tachoUnitText', svg).css({
        fontFamily: 'Goldman-Regular'
      });
      envTempText = hu('#envTempText', svg).css({
        fontFamily: 'Goldman-Regular'
      });
      clockText = hu('#clockText', svg).css({
        fontFamily: 'Goldman-Regular'
      });
      tempTextLow = hu('#tempTextLow', svg).css({
        fontFamily: 'Goldman-Regular'
      });
      tempTextMid = hu('#tempTextMid', svg).css({
        fontFamily: 'Goldman-Regular'
      });
      tempTextHigh = hu('#tempTextHigh', svg).css({
        fontFamily: 'Goldman-Regular'
      });
      tempTextUnit = hu('#tempTextUnit', svg).css({
        fontFamily: 'Goldman-Regular'
      });
      odoText = hu('#odoText', svg).css({
        fontFamily: 'Goldman-Regular'
      });
      tripText = hu('#tripText', svg).css({
        fontFamily: 'Goldman-Regular'
      });
      rangeText = hu('#rangeText', svg).css({
        fontFamily: 'Goldman-Regular'
      });
      modeText = hu('#modeText', svg).css({
        fontFamily: 'Goldman-Regular'
      });
      startline = hu('#startline', svg);

      //extra stuff just for fonts
      hu('#text4-4').css({
        fontFamily: 'Goldman-Regular'
      });
      hu('#text4-1').css({
        fontFamily: 'Goldman-Regular'
      });
      hu('#text4').css({
        fontFamily: 'Goldman-Regular'
      });
      hu('#text16-9').css({
        fontFamily: 'Goldman-Regular'
      });
      hu('#text16-9-6').css({
        fontFamily: 'Goldman-Regular'
      });
      hu('#text17').css({
        fontFamily: 'Goldman-Regular'
      });

      status.svg = true;
    }

    $window.setup = (data) => {
      initData = data;
      status.setup = true;
    }

    $window.updateMode = (data) => {
      if(!status.svg){
        console.log("calling updateMode while svg not fully loaded");
        setTimeout(function(){ $window.updateMode(data) }, 100);
        return;
      }
      modeText.text(data.modeName);
      if (data.sportLevel >= 1)
        modeText.css({fill:'#802919'});
      else
        modeText.css({fill:'white'});
      if (data.sportLevel >= 2)
        startline.attr({opacity:1});
      else
        startline.attr({opacity:0});
    }

    $window.updateData = (data) => {
      if (status.init)
      {
        updateNeedles(data);
        if (initData.uiUnitLength == 'metric')
          speedText.text(Math.floor(data.electrics.wheelspeed * 3.6));
        else
          speedText.text(Math.floor(data.electrics.wheelspeed * 3.6 * KMH_TO_MPH));

        let tempEnv = UiUnits.temperature(data.customModules.environmentData.temperatureEnv);
        if (tempEnv.val.toFixed(1) > 99.9 || tempEnv.val.toFixed(1) < -99.9) {
          envTempText.text("---°C");
        }else {
          envTempText.text(tempEnv.val.toFixed(1) + tempEnv.unit);
        }
        
        clockText.text(data.customModules.environmentData.time);

        if(data.electrics.odometer){
          let val = data.electrics.odometer;
          val *= (distSuffix=='km')?0.001:0.0006215;
          val = Math.min(999999,val);
          odoText.text( val.toFixed(0)+' '+distSuffix);
          val = data.electrics.trip;
          val *= (distSuffix=='km')?0.001:0.0006215;
          val %=1000;
          tripText.text( val.toFixed(1)+' '+distSuffix);
        }

        let range = data.customModules.electricMotorData.remainingRange;
        rangeText.text((range < 10000 ? range.toFixed(0) : 0) + ' ' + distSuffix);

        if (data.electrics.gear == 0)
          gearText.text('N');
        else if (data.electrics.gear == -1)
          gearText.text('R');
        else
          gearText.text(data.electrics.gear);

        let fuelLevelAngleDeg = (1 - data.electrics.fuel) * 45; 
        fuelLevel.attr({
          transform: `translate(-19.585821,11.926283) rotate(${fuelLevelAngleDeg} 300.6 183.1)`
        })
        let tempAmt = 1 - ((data.electrics.watertemp - 70) / 100);
        let tempLevelAngleDeg = tempAmt * -45;
        tempLevel.attr({
          transform: `rotate(${tempLevelAngleDeg} 743 195.5) scale(-1,1)`
        });

        let cba = smoothedRpmAmt * 2 - 1;

        if (cba >= 0)
        {
          tachoUnitText.text('POWER');
          tachoUnitText.css({fill:'#802919'});
        }
        else
        {
          tachoUnitText.text('CHARGE');
          tachoUnitText.css({fill:'white'});
        }
        tachoUnitText.attr({opacity: Math.abs(cba)});
      
        warnings.signal_L.attr({opacity: data.electrics.signal_L});
        warnings.signal_R.attr({opacity: data.electrics.signal_R});
        warnings.hazard.attr({opacity: data.electrics.hazard});
        warnings.checkengine.attr({opacity:data.electrics.checkengine});
        warnings.battery.attr({opacity:1-data.electrics.engineRunning});
        warnings.parkbrake.attr({opacity:data.electrics.parkingbrake > 0 ? 1 : 0});
        warnings.lowfuel.attr({opacity:data.electrics.lowfuel});
        warnings.lowpressure.attr({opacity:data.electrics.lowpressure});
        warnings.abs.attr({opacity:data.electrics.abs});
        warnings.esc.attr({opacity:data.electrics.esc});
        warnings.tcs.attr({opacity:data.electrics.tcs});
        warnings.foglight.attr({opacity:data.electrics.fog});
        warnings.rearfog.attr({opacity:data.electrics.fog});
        warnings.oil.attr({opacity:data.electrics.oil});
        warnings.lowbeam.attr({opacity:data.electrics.lights});
        warnings.highbeam.attr({opacity:data.electrics.highbeam});
      }
      else
        init();
    }

    function init()
    {
      if (!status.svg || !status.setup)
        return;

      //drawTacho();
      drawSpeedo();

      if (initData.uiUnitLength == 'metric')
      {
        speedUnitText.text('km/h');
        speedoUnitText.text('km/h');
        consSuffix = 'l/100km';
        distSuffix = 'km';
        
        tempTextLow.text('70');
        tempTextMid.text('120');
        tempTextHigh.text('170');
        tempTextUnit.text('°C');
      }
      else
      {
        speedUnitText.text('mph');
        speedoUnitText.text('mph');
        consSuffix = 'mpg';
        distSuffix = 'mi';

        tempTextLow.text('160');
        tempTextMid.text('250');
        tempTextHigh.text('340');
        tempTextUnit.text('°F');
      }

      status.init = true;
    }

    // thanks mrcin for smoothing code
    function updateNeedles(data)
    {
      let speedAmt = Math.max(Math.min(data.electrics.wheelspeed * 3.6 / initData.maxKPH, 1), 0);
      let speedoAngleDeg = gaugeAngleDeg * speedAmt - speedoStartAngleDeg;

      speedoNeedle.attr({
      transform: `rotate(${speedoAngleDeg} 281 195)`
        });

      let rpmRaw = (data.customModules.electricMotorData.electricPowerDisplay + 1) / 2;
      smoothedRpmAmt += (rpmRaw - smoothedRpmAmt) * 0.1;
      let tachoAngleDeg = gaugeAngleDeg * smoothedRpmAmt - tachoStartAngleDeg;

      tachoNeedle.attr({
          transform: `translate(461.25) rotate(${tachoAngleDeg} 281 195)`
      });
    }
    function drawTacho()
    {
      const startAngleDeg = 180;
      const centerX = 743;
      const centerY = 195.5;
      const lineLengthPrimary = 25;
      const lineLengthSecondary = 20;
      const lineWidth = 2;
      const lineWidthRed = 4;

      const numFontSize = 26;
      const numOffset = 14;

      let lineAmt = Math.ceil(initData.maxRPM * 0.001) * 2;
      let redline = Math.ceil(initData.redRPM * 0.001) * 2;
      let stepAngleDeg = gaugeAngleDeg / lineAmt;
      
      for (let i = 0; i <= lineAmt; i++)
      {
        let px = centerX + gaugeRadius * Math.cos(degToRad(startAngleDeg + stepAngleDeg * i));
        let py = centerY + gaugeRadius * Math.sin(degToRad(startAngleDeg + stepAngleDeg * i));
        
        let base = hu('<g>', svg)
        .attr({
          transform: `rotate(${stepAngleDeg * i} ${px} ${py})`
        });
        let line = hu('<rect>', base);
        
        if (i % 2 == 0) //primary line
        {
          line.attr({
            x: px, y: py,
            width: lineLengthPrimary,
            height: lineWidth
          }).css({
            fill: 'url(#lineGradientPrimary)'
          });

          let tx = centerX + (gaugeRadius - lineLengthPrimary - numOffset) * Math.cos(degToRad(startAngleDeg + stepAngleDeg * i));
          let ty = centerY + (gaugeRadius - lineLengthPrimary - numOffset) * Math.sin(degToRad(startAngleDeg + stepAngleDeg * i));

          let num = hu('<text>', svg)
          .attr({
            x: tx, y: ty,
            textAnchor:"middle", alignmentBaseline:"middle",
          })
          .css({
            fill: 'white',
            font: `${numFontSize}px regular`,
            fontFamily: 'Goldman-Regular'
          })
          .text(i / 2);
        }
        else //secondary line
        {
          line.attr({
            x: px, y: py,
            width: lineLengthSecondary,
            height: lineWidth
          }).css({
            fill: 'url(#lineGradientSecondary)'
          });
        }
        if (i >= redline)
        {
          line.attr({
            x: px, y: py,
            width: lineLengthPrimary,
            height: lineWidthRed
          }).css({
            fill: 'url(#lineGradientRed)'
          });
        }
      }

      //draw redline arc
      /*
      const rarcOffset = 6;
      const rarcWidth = 4;
      let rx1 = centerX + (gaugeRadius - rarcOffset) * Math.cos(degToRad(startAngleDeg + stepAngleDeg * redline));
      let ry1 = centerY + (gaugeRadius - rarcOffset) * Math.sin(degToRad(startAngleDeg + stepAngleDeg * redline));
      let rx2 = centerX + (gaugeRadius - rarcOffset) * Math.cos(degToRad(startAngleDeg + stepAngleDeg * lineAmt));
      let ry2 = centerY + (gaugeRadius - rarcOffset) * Math.sin(degToRad(startAngleDeg + stepAngleDeg * lineAmt));
      let rarc = hu('<path>', svg).attr({
        d: `M ${rx1} ${ry1} A ${gaugeRadius - rarcOffset} ${gaugeRadius - rarcOffset} 0 0 1 ${rx2} ${ry2}`,
        stroke: 'red',
        fill: 'none',
        strokeWidth: rarcWidth
      });
      */
    }

    function drawSpeedo()
    {
      const smallStepSpeed = 200;

      const startAngleDeg = 135;
      const centerX = 281;
      const centerY = 195.5;
      const lineLengthPrimary = 25;
      const lineLengthSecondary = 20;
      const lineWidth = 2;

      const numFontSize = 20;
      const numOffset = 20;

      let maxSpeed;
      if (initData.uiUnitLength == 'metric')
        maxSpeed = initData.maxKPH;
      else
        maxSpeed = initData.maxMPH;
      let lineAmt = Math.ceil(maxSpeed * 0.1);
      let stepAngleDeg = gaugeAngleDeg / lineAmt;
      
      for (let i = 0; i <= lineAmt; i++)
      {
        let px = centerX + gaugeRadius * Math.cos(degToRad(startAngleDeg + stepAngleDeg * i));
        let py = centerY + gaugeRadius * Math.sin(degToRad(startAngleDeg + stepAngleDeg * i));
        
        let base = hu('<g>', svg)
        .attr({
          transform: `rotate(${stepAngleDeg * i + startAngleDeg + 180} ${px} ${py})`
        });
        let line = hu('<rect>', base);
        
        if ((i % 2 == 0 && maxSpeed <= smallStepSpeed) || i % 4 == 0)// || (i % 2 == 0 && i <= 10)) //primary line
        {
          line.attr({
            x: px, y: py,
            width: lineLengthPrimary,
            height: lineWidth
          }).css({
            fill: 'url(#lineGradientPrimary)'
          });

          let tx = centerX + (gaugeRadius - lineLengthPrimary - numOffset) * Math.cos(degToRad(startAngleDeg + stepAngleDeg * i));
          let ty = centerY + (gaugeRadius - lineLengthPrimary - numOffset) * Math.sin(degToRad(startAngleDeg + stepAngleDeg * i));

          let num = hu('<text>', svg)
          .attr({
            x: tx, y: ty,
            textAnchor:"middle", alignmentBaseline:"middle",
          })
          .css({
            fill: 'white',
            font: `${numFontSize}px regular`,
            fontFamily: 'Goldman-Regular'
          });
          num.text(i * 10);
        }
        else //secondary line
        {
          line.attr({
            x: px, y: py,
            width: lineLengthSecondary,
            height: lineWidth
          }).css({
            fill: 'url(#lineGradientSecondary)'
          });
        }
      }
    }
  }
);