local M = {}

local leftIsOn = false
local rightIsOn = false

local steerAngle = 0

local function updateGFX()
    if electrics.values.lowhighbeam == 1 and electrics.values.hazard_enabled == 0 then
        rightIsOn = (electrics.values.wheelspeed > 1 and electrics.values.steering < -steerAngle) or electrics.values.signal_right_input == 1
        leftIsOn = (electrics.values.wheelspeed > 1 and electrics.values.steering > steerAngle) or electrics.values.signal_left_input == 1
    else
        leftIsOn = false
        rightIsOn = false
    end

    electrics.values.cornering_L = leftIsOn and 1 or 0
    electrics.values.cornering_R = rightIsOn and 1 or 0
end

local function init(jbeamData)
    steerAngle = jbeamData.steerAngle or 50

    electrics.values.cornering_R = 0
    electrics.values.cornering_L = 0

    leftIsOn = false
    rightIsOn = false
end

M.reset = init
M.init = init
M.updateGFX = updateGFX

return M