-- written by DaddelZeit
-- DO NOT USE WITHOUT PERMISSION

local M = {}

local amountOfSteps = 14

local signalTimer = 0
local signalTimerEnd = 0.1
local speedModifier = 5.5

local function clearSignals()
    for i = 1, amountOfSteps, 1 do
        electrics.values['signal_R'..tostring(i)] = 0
        electrics.values['signal_L'..tostring(i)] = 0
        signalTimer = 0
    end
end

local function init(jbeamData)
    amountOfSteps = jbeamData.amountOfSteps or 10
    speedModifier = jbeamData.speedModifier or 5
    signalTimerEnd = (jbeamData.signalTimerEnd or 4)
    clearSignals()
end

local function updateGFX(dt)
    if electrics.values.signal_left_input == 0 and electrics.values.signal_right_input == 0 then clearSignals() return end
    signalTimer = signalTimer + dt
    if amountOfSteps then
        for i = 1, amountOfSteps, 1 do
            electrics.values["signal_R"..tostring(i)] = (electrics.values.signal_right_input == 1 and (speedModifier/100 * i < signalTimer) or 0)
            electrics.values["signal_L"..tostring(i)] = (electrics.values.signal_left_input == 1 and (speedModifier/100 * i < signalTimer) or 0)
        end
        if signalTimer >= signalTimerEnd then signalTimer = 0 end
    end
end

-- public interface
M.updateGFX = updateGFX
M.init = init
M.reset = clearSignals -- call clearSignals() on reset

return M