-- Made by Neverless @ BeamMP. Problems, Questions or requests? Feel free to ask.
-- WIP
--[[
	Standalone module. Not required to operate the PathC library. Just a helper to help creating and editing pathes.
]]

package.loaded[mainLevel.findLib("libs/PathC")] = nil
local PathC = require(mainLevel.findLib("libs/PathC"))

package.loaded[mainLevel.findLib("libs/PathCRender")] = nil
local PathCRender = require(mainLevel.findLib("libs/PathCRender"))

local M = {}

local SAVE_PATH = mainLevel.luaPath() .. '/PathC/'
local FILE_EXTENSION = 'pathC'
local OPENED_FILE_NAME = nil

local Path = PathC()
local PathRender = PathCRender():setPath(Path):renderDistance(300):buildJob(true)
local TRIGGER_RERENDER = false

--[[
	Format
	[1..n] = vec3
]]
local RECORDING = false

local IS_EDITING = false

--[[
	Format
	["obj_id"] = index in path
]]
local WAYPOINTS = {}
local WAYPOINTS_SELECTED = {}

-- -------------------------------------------------------------------------------
-- Common
local function dist2d(p1, p2)
	return math.sqrt((p2.x - p1.x)^2 + (p2.y - p1.y)^2)
end

local function dist3d(p1, p2)
	return math.sqrt((p2.x - p1.x)^2 + (p2.y - p1.y)^2 + (p2.z - p1.z)^2)
end

local function getRandomFileName(path, file_name, extension)
	local index = 0
	while true do
		local check = path .. file_name .. '_' .. index .. '.' .. extension
		if not FS:fileExists(check) then return file_name .. '_' .. index end
		index = index + 1
	end
end

local function getRandomObjectName(obj_name)
	local index = 0
	while true do
		local check = obj_name .. '_' .. index
		if not scenetree.findObject(check) then return check end
		index = index + 1
	end
end

-- -------------------------------------------------------------------------------
-- Render
local function pathRenderRoutine()
	if TRIGGER_RERENDER then
		PathRender:build()
		TRIGGER_RERENDER = false
	end
	
	PathRender:render()
end

-- -------------------------------------------------------------------------------
-- Recorder
local function recordRoutine(dt)
	if simTimeAuthority.getPause() then return end
	
	local vehicle = getPlayerVehicle(0)
	if not vehicle then return end
	
	local veh_pos = vehicle:getSpawnWorldOOBB():getCenter()
	
	local last_point = Path:getLast()
	if not last_point or (dist3d(last_point.pos, veh_pos) > 0.1) then
		Path:add(veh_pos)
	end
end

M.toggleRecord = function()
	RECORDING = not RECORDING
end

-- -------------------------------------------------------------------------------
-- World Editor stuff
local function newWaypoint(pos, parent_group)
	local obj = createObject("BeamNGWaypoint")
	obj:setPosition(pos)
	obj:registerObject(getRandomObjectName('sector_wp'))
	obj:setField("parentGroup", 0, parent_group:getId())
	obj.canSave = false
	obj.canSaveDynamicFields = false
	obj.isRenderEnabled = false
	return obj
end

local function newSimGroup(name, parent_group)
	local obj = createObject("SimGroup")
	obj:registerObject(name)
	obj:setField("parentGroup", 0, parent_group:getId())
	obj.canSave = false
	obj.canSaveDynamicFields = false
	return obj
end

-- -------------------------------------------------------------------------------
-- Editor
local function editorRoutineJob(job)
	while IS_EDITING do
		local w_sleep = math.floor(Path:getCount() / 10)
		if w_sleep > 100 then w_sleep = 100 end
		
		for obj_id, index in pairs(WAYPOINTS) do
			local obj = scenetree.findObjectById(obj_id)
			if not obj then
				WAYPOINTS[obj_id] = nil
			else
				if obj:isSelected() then
					WAYPOINTS_SELECTED[obj_id] = index
					obj.isSelectionEnabled = false
				end
			end
			
			if (index % w_sleep) == 0 then job.yield() end
		end
	end
end

local function editorRoutineJobSelected(job)
	while IS_EDITING do
		job.yield()
		for obj_id, index in pairs(WAYPOINTS_SELECTED) do
			local obj = scenetree.findObjectById(obj_id)
			if not obj then
				WAYPOINTS_SELECTED[obj_id] = nil
			else
				if not obj:isSelected() then
					obj.isSelectionEnabled = true
					WAYPOINTS_SELECTED[obj_id] = nil
				end
				
				Path:get(index).size = obj:getScale().x
				Path:getPosAsRef(index):set(obj:getPosition())
			end
		end
	end
end

M.spawn = function()
	if IS_EDITING then return end
	IS_EDITING = true
	core_jobsystem.create(editorRoutineJob, 0)
	core_jobsystem.create(editorRoutineJobSelected, 0)
	Path:setLock(true) -- we need to support add/rem first
	
	local mission_group = scenetree.findObject('MissionGroup')
	local sim_group = scenetree.findObject('PathCEditor') or newSimGroup('PathCEditor', mission_group)
	
	local scale = vec3(0, 0, 0)
	local last_rot = QuatF(0, 0, 0, 0)
	for index, point in Path:ipairs() do
		local pos = point.pos
		local obj = newWaypoint(pos, sim_group)
		WAYPOINTS[obj:getId()] = index
		
		scale:set(point.size, point.size, point.size)
		obj:setScale(scale)
		
		if Path:get(index + 1) then
			last_rot = quatFromDir((Path:getPosAsRef(index + 1) - point.pos):normalized(), vec3(0, 0, 1))
		end
		obj:setPosRot(pos.x, pos.y, pos.z, last_rot.x, last_rot.y, last_rot.z, last_rot.w)
	end
end

M.despawn = function()
	if not IS_EDITING then return end
	IS_EDITING = false
	Path:setLock(false)
	
	for obj_id, _ in pairs(WAYPOINTS) do
		local obj = scenetree.findObjectById(obj_id)
		if obj then obj:delete() end
	end
	WAYPOINTS = {}
end

M.editGlobalSize = function(size)
	for _, point in Path:ipairs() do
		point.size = size
	end
end

M.editSize = function(index, size)
	Path:setSize(index, size)
end

-- -------------------------------------------------------------------------------
-- Save/Load
M.loadPath = function(file_name)
	M.despawn()
	
	local file_path = SAVE_PATH .. file_name .. '.' .. FILE_EXTENSION
	if not FS:fileExists(file_path) then
		log('E', 'Cannot find file')
		return
	end
	
	local handle = io.open(file_path, 'r')
	if not handle then
		log('E', 'Cannot open file in read mode')
		return
	end
	
	local path = handle:read('*all')
	handle:close()
	
	Path:reset():fromJson(path)
	OPENED_FILE_NAME = file_name
	
	log('I', 'Loaded "' .. file_name .. '"')
	
	TRIGGER_RERENDER = true
end

M.savePath = function(save_as)
	local file_name = save_as or OPENED_FILE_NAME or getRandomFileName(SAVE_PATH, 'path', FILE_EXTENSION)
	local save_path = SAVE_PATH .. file_name .. '.' .. FILE_EXTENSION
	local handle = io.open(save_path, 'w')
	if not handle then
		log('E', 'Cannot open file "' .. file_name .. '" in write mode')
		return
	end
	
	handle:write(Path:toJson())
	handle:close()
	
	log('I', 'Saved "' .. file_name .. '"')
end

-- -------------------------------------------------------------------------------
-- Game Events
M.onUpdate = function(dt_real)
	if RECORDING then recordRoutine(dt_real) end
	pathRenderRoutine()
end

M.onExtensionLoaded = function()
	if not FS:directoryExists(SAVE_PATH) then FS:directoryCreate(SAVE_PATH) end
	
	-- testing
	--M.loadPath('path_1')
	--Path:smooth(2)
	--M.editGlobalSize(7)
	--M.spawn()
end

M.onExtensionUnloaded = function()
	PathRender:buildJob(false)
	M.despawn()
end

-- -------------------------------------------------------------------------------
-- Direct access
M.Path = Path
M.PathRender = PathRender

return M
