-- Made by Neverless @ BeamMP. Problems, Questions or requests? Feel free to ask.
-- WIP

package.loaded[mainLevel.findLib("libs/PathC")] = nil
local PathC = require(mainLevel.findLib("libs/PathC"))

package.loaded[mainLevel.findLib("libs/PosMapC")] = nil
local PosMapC = require(mainLevel.findLib("libs/PosMapC"))

local M = {}
local SAVE_PATH = mainLevel.luaPath() .. '/PosMapC/'
local SAVE_PATH_PATHC = mainLevel.luaPath() .. '/PathC/'
local FILE_EXTENSION = 'posmapC'

local Path = PathC()
local PosMap = PosMapC()

-- -------------------------------------------------------------------------------
-- Common
local function getRandomFileName(path, file_name, extension)
	local index = 0
	while true do
		local check = path .. file_name .. '_' .. index .. '.' .. extension
		if not FS:fileExists(check) then return file_name .. '_' .. index end
		index = index + 1
	end
end

-- -------------------------------------------------------------------------------
-- Editor
M.build = function()
	PosMap:reset():buildFromPath(Path)
end

M.loadPath = function(file_name)
	Path:reset():fromJson(jsonReadFile(SAVE_PATH_PATHC .. file_name .. '.pathC'))
end

M.load = function(file_name)
	local save_path = SAVE_PATH .. file_name .. '.' .. FILE_EXTENSION
	PosMap:reset():fromJson(jsonReadFile(save_path))
end

M.save = function(save_as)
	local file_name = save_as or getRandomFileName(SAVE_PATH, 'posmap', FILE_EXTENSION)
	local save_path = SAVE_PATH .. file_name .. '.' .. FILE_EXTENSION
	local handle = io.open(save_path, 'w')
	if not handle then
		log('E', 'Cannot open file "' .. file_name .. '" in write mode')
		return
	end
	
	handle:write(PosMap:toJson())
	handle:close()
	
	log('I', 'Saved "' .. file_name .. '"')
end

-- -------------------------------------------------------------------------------
-- Game Events
--[[
M.onUpdate = function()
	local vehicle = getPlayerVehicle(0)
	if not vehicle then return end
	
	local veh_pos = vehicle:getPosition()
	local point = PosMap:getPoint3d(veh_pos)
	if point then
		dump(point.value.distance, point.value.completion)
	end
end
]]

M.onExtensionLoaded = function()
	if not FS:directoryExists(SAVE_PATH) then FS:directoryCreate(SAVE_PATH) end
	
	--M.loadPath('path_1')
	--M.build()
	--M.load('path_1')
end

M.onExtensionUnloaded = function()
	
end


return M
