-- Made by Neverless @ BeamMP. Problems, Questions or requests? Feel free to ask.
-- WIP
local PathC = require(mainLevel.findLib("libs/PathC"))

local M = {}

local BRUSHES = {}

-- -------------------------------------------------------------------------------
-- Common
local function createBrush(radius)
	if BRUSHES[radius] then return BRUSHES[radius] end
	
	local brush = {}
	for i = 1, radius do
		for angle = 0, 360 do
			table.insert(brush, {
				x = i * math.cos(angle),
				y = i * math.sin(angle)
			})
		end
	end
	
	BRUSHES[radius] = brush
	return brush
end

local function vec3ToXY(vec)
	return math.floor(vec.x) .. ' ' .. math.floor(vec.y)
end

local function dist2d(p1, p2)
	return math.sqrt((p2.x - p1.x)^2 + (p2.y - p1.y)^2)
end

local function inRange(a, x, b)
	return x >= a and x <= b
end

local function verifyPath(path)
	local total_distance = 0
	for index, point in path:ipairs() do
		local p2 = path:get(index - 1)
		if p2 then
			local distance = dist2d(point.pos, p2.pos)
			total_distance = total_distance + distance
			if distance > 5 then
				print(distance)
				return false
			end
		end
	end
	
	return total_distance
end

-- -------------------------------------------------------------------------------
-- Class
local function new()
	--[[
		Format
		[_path] = PathC (locked)
			where
			[pos] = vec3
			[size] = int
			[value] = table
				[distance] = float
				[completion] = float
				[...] = any other from any user
		[_posmap] = table
			["x y"] = int (index that references the point from PathC)
	]]
	local posmap = {
		_path = nil,
		_posmap = {}
	}
	
	function posmap:buildFromPath(path)
		if self._path then
			log('E', 'PosMapC', 'A posmap can only be linked to a single PathC')
			return
		end
		local total_distance = verifyPath(path)
		if not total_distance then
			log('E', 'PosMapC', 'Points of PathC must NOT be further apart then 2.5 meters from each other')
			return
		end
		
		local total_points = path:getCount()
		for index, point in path:ipairs() do
			-- path point pos and size edit
			local pos = point.pos
			pos:set(math.floor(pos.x), math.floor(pos.y), math.floor(pos.z))
			point.size = round(point.size)
			
			-- path point value edit
			local value = point.value or {}
			value.distance = (total_distance / total_points) * index
			value.completion = (value.distance / total_distance) * 100
			point.value = value
			
			-- brush posmap
			local brush = createBrush(point.size)
			local posmap = self._posmap
			for _, xy in ipairs(brush) do
				local xy = math.floor(pos.x + xy.x) .. ' ' .. math.floor(pos.y + xy.y)
				posmap[xy] = index
			end
		end
		
		path:setLock(true)
		self._path = path
		return self
	end
	
	-- ---------------------------------------------------------------------------------
	-- Getters
	function posmap:getCenter3d(vec) -- returns index of PathC
		return self._posmap[vec3ToXY(vec)]
	end
	
	function posmap:getCenter(xy) -- returns index of PathC
		return self._posmap[xy]
	end
	
	function posmap:getPoint3d(vec) -- returns point of pathC
		return self._path:get(self:getCenter3d(vec))
	end
	
	function posmap:getPoint(xy) -- returns point of PathC
		return self._path:get(self:getCenter(xy))
	end
	
	function posmap:getPath() return self._path end
	
	-- ---------------------------------------------------------------------------------
	-- Util
	function posmap:contains3d(vec)
		return self:contains(vec3ToXY(vec))
	end
	
	function posmap:contains(xy)
		return self._posmap[xy] ~= nil
	end
	
	function posmap:reset()
		self._path = nil
		self._posmap = {}
		return self
	end
	
	-- ---------------------------------------------------------------------------------
	-- File serialization
	function posmap:toJson()
		if not self._path then return end
		local data = {
			path = jsonDecode(self._path:toJson()),
			posmap = self._posmap
		}
		return jsonEncode(data)
	end
	
	function posmap:fromJson(data)
		if self._path then return end
		if type(data) ~= "table" then data = jsonDecode(data) end
		
		self._path = PathC():fromJson(data.path)
		self._posmap = data.posmap
		return self
	end
	
	return posmap
end

setmetatable(M, {
	__call = new
})

return M
