-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt

local M = {}

local function onInit()
 electrics.values.vwSpeedoLow = 0
 electrics.values.vwSpeedoHigh = 0
 electrics.values.vwSpeedo = 0
end

local function updateGFX(dt)
electrics.values.vwSpeedoLow = electrics.values.wheelspeed
electrics.values.vwSpeedoHigh = 8.3295 + (electrics.values.wheelspeed / 2)
 if electrics.values.wheelspeed < 16.66 then 
    electrics.values.vwSpeedo = electrics.values.vwSpeedoLow  
 else
    electrics.values.vwSpeedo = electrics.values.vwSpeedoHigh
 end
end

-- public interface

M.onInit      = onInit
M.onReset     = onInit
M.updateGFX = updateGFX

return M
