-- written by DaddelZeit
-- DO NOT USE WITHOUT PERMISSION

local M = {}

local autoHeadlightsEnabled = false
local autoHeadlightsData = {}

local checktimer = 0
local lightUpdatedTimer = 0
local manuallyTurnedOff = false

local lightBaseVal = 0
local highBeamsVal = 0
local value = 0
local lastValue = -1

local function getHighBeam(ownVeh, mailboxData)
    for otherVehId,otherVeh in pairs(mailboxData) do
        if otherVeh.lightsActive then
            local result1, result2 = intersectsRay_OBB(ownVeh.center, obj:getForwardVector(), otherVeh.center, otherVeh.x15, otherVeh.y2, otherVeh.z15)
            if (result1 ~= math.huge and result1 >= 0) or (result2 ~= math.huge and result2 >= 0) then
                -- check if the car is behind eg. a wall
                local staticRay = obj:castRayStatic(ownVeh.center, otherVeh.center-ownVeh.center, 800)
                if (staticRay or math.huge) >= ownVeh.center:distance(otherVeh.center) then
                    return 0
                end
            end
        end
    end

    return 1
end

local function zeitADASUpdate(dt, mailboxData)
    checktimer = checktimer + dt
    if checktimer > 0.15 then checktimer = 0 else return end
    if not mailboxData or not next(mailboxData) or not autoHeadlightsEnabled then return end

    local ownVeh = mailboxData[objectId] or {}
    mailboxData[objectId] = nil
    if not next(ownVeh) or not ownVeh.ambColor then return end

    if highBeamsVal == 1 and electrics.values.lights_state < 2 then
        manuallyTurnedOff = true
    else
        manuallyTurnedOff = false
    end

    lightBaseVal = ownVeh.ambColor < 0.7 and 1 or 0
    highBeamsVal = autoHeadlightsData.highBeamCheck and (ownVeh.ambColor < 0.7 and getHighBeam(ownVeh, mailboxData) or 0) or 0
    value = lightBaseVal+highBeamsVal

    if value ~= lastValue and not manuallyTurnedOff or (electrics.values.lights_state == 2 and value == 1) then
        if value ~= 2 then electrics.setLightsState(value) end
    end

    if electrics.values.lights_state == 1 and value == 2 then
        lightUpdatedTimer = lightUpdatedTimer + dt
        if lightUpdatedTimer > 0.5 then
            electrics.setLightsState(2)
            lightUpdatedTimer = 0
        end
    end

    lastValue = value
end

local function reset()
    manuallyTurnedOff = false
end

local function init(jbeamData)
    autoHeadlightsEnabled = next(jbeamData) ~= nil
    autoHeadlightsData = jbeamData
end

M.init = init
M.reset = reset
M.zeitADASUpdate = zeitADASUpdate

return M