
local M = {}

local _TYPE_UNKNOWN= 0
local _TYPE_TARGET= 1
local _TYPE_FRIEND= 2
local _TYPE_DEVICE= 3
local _TYPE_PROVIDER= 4

local function getObjectType(model)

  local typeName= string.lower(model.Type)
  local halflifeType= model.halflife_type and string.lower(model.halflife_type) or ""
  
  if typeName == "prop" then
    if halflifeType == "magnusson_device" then return _TYPE_DEVICE end
    if halflifeType == "magnusson_provider" then return _TYPE_PROVIDER end
  else
    if halflifeType == "vehicle" then return _TYPE_FRIEND end
    return _TYPE_TARGET
  end

  return _TYPE_UNKNOWN
end

local function toFixedTwo(num)
  return math.floor(num*100)*0.01
end

local function getAllObjectLocations2D(requesterID)

  requesterID= tonumber(requesterID)

  local vehr = be:getObjectByID(requesterID)
  if not vehr then return end

  local vehicleCache= getAllVehicles()

  local targetList= ""
  local friendList= ""
  local deviceList= ""
  local providerList= ""

  local vec

  for _,veh in pairs(vehicleCache) do

    if veh:getId() ~= requesterID then

      local type= getObjectType(core_vehicles.getModel(veh.jbeam).model)

      if type ~= _TYPE_UNKNOWN then

        vec = veh:getPosition()

        if type== _TYPE_TARGET then
          targetList= targetList..';'.. toFixedTwo(vec.x) ..','.. toFixedTwo(vec.y)
          --print("got a target")
        elseif type== _TYPE_FRIEND then
          friendList= friendList..';'.. toFixedTwo(vec.x) ..','.. toFixedTwo(vec.y)
          --print("got a friend")
        elseif type== _TYPE_DEVICE then
          deviceList= deviceList..';'.. toFixedTwo(vec.x) ..','.. toFixedTwo(vec.y)
          --print("got a device")
        elseif type== _TYPE_PROVIDER then
          providerList= providerList..';'.. toFixedTwo(vec.x) ..','.. toFixedTwo(vec.y)
          --print("got a provider")
        end

      end
    end

  end

  if targetList ~= "" then targetList= string.sub(targetList,2) end
  if friendList ~= "" then friendList= string.sub(friendList,2) end
  if deviceList ~= "" then deviceList= string.sub(deviceList,2) end
  if providerList ~= "" then providerList= string.sub(providerList,2) end

  local cmd= "updateObjectLocations(\""..targetList.."|"..friendList.."|"..deviceList.."|"..providerList.."\")"
  vehr:queueLuaCommand(cmd)
end

M.getAllObjectLocations2D = getAllObjectLocations2D
M.getClosestMagnussonDevice = getClosestMagnussonDevice

return M