
local M = {}

local function isValidType(model, type)
  local typeName= string.lower(model.Type)
  local halflifeType= model.halflife_type and string.lower(model.halflife_type) or ""
  return typeName == "prop" and halflifeType == type
end

local function getClosestHalflifeObject(requesterID, type)

  local vehr = be:getObjectByID(requesterID)
  if not vehr then return end

  local vehicleCache= getAllVehicles()

  local vehrPos= vehr:getPosition()

  local distance= -1
  local objectID= -1

  for _,veh in pairs(vehicleCache) do
    if veh:getId() ~= requesterID and isValidType(core_vehicles.getModel(veh.jbeam).model, type) then
      local dist = (veh:getPosition() - vehrPos).length
      if dist < distance then
        distance= dist
        objectID= veh:getID()
      end
    end
  end

  local cmd= "closestObjectReceiverCallback(\""..type.."|"..objectID.."|"..distance.."\")"
  vehr:queueLuaCommand(cmd)
end

local function getClosestMagnussonDevice(requesterID)
  getClosestHalflifeObject(requesterID, "magnusson_device")
end

local function getClosestMagnussonStation(requesterID)
  getClosestHalflifeObject(requesterID, "magnusson_station")
end

local function callHalflifeObjectLua(objectID, requesterID, type, func, args)

  local device = be:getObjectByID(objectID)
  local vehr = be:getObjectByID(requesterID)

  if not device or not vehr then return end

  if isValidType(core_vehicles.getModel(device.jbeam).model, type) then

    local argsFinal= "\"..requesterID..\""

    if type(args) == "table" then
      argsFinal= argsFinal.."|\""..table.concat(args,"\"|\"").."\""
    elseif args and args ~="" then
      argsFinal= argsFinal.."|\""..args.."\""
    end

    device:queueLuaCommand(func.."("..argsFinal..")")
  end

end

local function callMagnussonDeviceLua(objectID, requesterID, func, args)
  callHalflifeObjectLua(objectID, requesterID, "magnusson_device", func, args)
end

local function callMagnussonStationLua(objectID, requesterID, func, args)
  callHalflifeObjectLua(objectID, requesterID, "magnusson_station", func, args)
end

M.getClosestMagnussonDevice = getClosestMagnussonDevice
M.callMagnussonDeviceLua = callMagnussonDeviceLua

M.getClosestMagnussonStation = getClosestMagnussonStation
M.callMagnussonStationLua = callMagnussonStationLua

return M