
const 
  _READYSTATE_NULL=     0,
  _READYSTATE_OFF=      1,
  _READYSTATE_SETUP=    2,
  _READYSTATE_RUN=      3;

const 
  _BROKENSTATE_NORMAL=   0,
  _BROKENSTATE_DAMAGED=  1,
  _BROKENSTATE_BROKEN=   2;

export class spzJunkerRadar {

	//devtext= document.getElementById("devtext");

  texData= {};

	root= document.querySelector(":root");
  radarContainer = document.getElementById('radar-container');

	scrScanlines= document.getElementById('scanlines');
	scrNoise= document.getElementById('noise');
	scrRadar= document.getElementById('radar');
	
	scrMap = document.getElementById('map');

	iconSpawn;
  radarIcons= [
    {
      icons: [],
      container: document.getElementById('target-container'),
      template: document.getElementById('template-icon-target'),
    },
    {
      icons: [],
      container: document.getElementById('friend-container'),
      template: document.getElementById('template-icon-friend'),
    },
    {
      icons: [],
      container: document.getElementById('device-container'),
      template: document.getElementById('template-icon-device'),
    },
    {
      icons: [],
      container: document.getElementById('provider-container'),
      template: document.getElementById('template-icon-provider'),
    }
  ]

  static canInit(elms, opts) {
    return true;
  }
  
  init(texData){

    const 
      l_texSizeHalf= texData.texSize*.5,
      l_iconSize= texData.texSize*.1625;

    const ldata= {
      ...texData,
      texSizeHalf: l_texSizeHalf,
      iconSize: l_iconSize,
      iconSizeHalf: l_iconSize *.5,
      iconGlitchOffset: l_iconSize * .15,
      iconDistanceMax: l_texSizeHalf * .985,
      scrMapUnitScale: 1.125
    }
    this.texData= ldata;

    const css= this.root.style
    css.setProperty("--radar-screen-px", `${ldata.texSize}px`)
    css.setProperty("--radar-screen-pxh", `${ldata.texSizeHalf}px`)
    css.setProperty("--radar-noise-px", `${ldata.texSizeHalf}px`)
    css.setProperty("--radar-icon-px", `${ldata.iconSize}px`)
    css.setProperty("--radar-icon-npxh", `-${ldata.iconSizeHalf}px`)
    css.setProperty("--radar-offset-y", "0");
    css.setProperty("--radar-background-img", 'url("scr_bg.png")');
    css.setProperty("--radar-scanlines-y", "0")
    css.setProperty("--radar-scanlines-a", "0.30")
    css.setProperty("--radar-noise-x", "0")
    css.setProperty("--radar-noise-y", "0")
    css.setProperty("--radar-noise-a", "0.12")

    this.updateState([ldata.readyState, ldata.brokenState])

    const lspawn= document.getElementsByClassName('i-base')[0];

    this.iconSpawn= {
      style: lspawn.style,
      image: lspawn.children[0].style,
      image_glitch: lspawn.children[1].style,
      display: true,
    }
	}

  updateState([newReady, newBroken]){

    const ldata= this.texData

		ldata.readyState= newReady;
		ldata.brokenState= newBroken;
    
    this.radarContainer.style.setProperty("display", (newReady == _READYSTATE_RUN && newBroken < _BROKENSTATE_BROKEN) ? "block" : "none")
	}

  updateObjects(objectListStr){
    
    const typesList= objectListStr.split('|')

    this.updateIconList(typesList[0], this.radarIcons[0]) 
    this.updateIconList(typesList[1], this.radarIcons[1]) 
    this.updateIconList(typesList[2], this.radarIcons[2]) 
    this.updateIconList(typesList[3], this.radarIcons[3])
  }

  updateIconList(vecListStr, { container, icons, template }){

    let vecList= []

    if(vecListStr != null && vecListStr.length > 0){

      vecList= vecListStr.split(';').map(e=>{
        const vc= e.split(',')
        return {x:parseFloat(vc[0]), y:parseFloat(vc[1])}
      })
    }

    let i= 0, il= icons.length

    for(let j= i; j< il; j++){
      icons[j].display= false
      icons[j].style.setProperty("display", "none");
    }
    for(i in vecList){
      if(i >= il){
        let element = template.content.cloneNode(true).children[0];
        container.appendChild(element);
        icons.push({
          style: element.style,
          image: element.children[0].style,
          image_glitch: element.children[1].style,
          position: vecList[i]
        })
      }
      else {
        icons[i].position= vecList[i]
      }
      icons[i].display= true
      icons[i].style.setProperty("display", "block");
    }
  }

  update(updateData){

    const ldata= this.texData
    
		if (ldata.brokenState < _BROKENSTATE_BROKEN && ldata.readyState == _READYSTATE_RUN){

      let css= this.root.style;
      
      css.setProperty("--radar-scanlines-y", ldata.texSize * updateData.animProgress + "px")
			css.setProperty("--radar-noise-x", ldata.texSize * Math.random() + "px");
			css.setProperty("--radar-noise-y", ldata.texSize * Math.random() + "px");

      css.setProperty("--radar-scanlines-a", 0.20+Math.random()*0.06);
				
			if (ldata.brokenState == _BROKENSTATE_DAMAGED){

        css.setProperty("--radar-noise-a", 0.14+Math.random()*0.62);

        if (Math.random() < .26){

          let la= ldata.texSize * .65;
          let lb= la * .5;
  
          css.setProperty("--radar-offset-y", -lb + la * Math.random() + "px");
        }
        else{
          css.setProperty("--radar-offset-y", "0");
        }

        css.setProperty("--radar-background-img", Math.random() < .12 ? 'url("scr_bg_glitch.png")' : 'url("scr_bg.png")');
			}

      css.setProperty("--radar-map-deg", updateData.playerCoords.rot + "deg");
      this.updateIconPosition(updateData.playerCoords, this.iconSpawn, ldata.spawnPoint);
      
      for(let i=0; i< 4; i++){
        if(this.radarIcons[i].icons.length > 0){
          for(let icon of this.radarIcons[i].icons){
            this.updateIconPosition(updateData.playerCoords, icon, icon.position)
          }
        }
      }
		}
	}

  updateIconPosition(center, icon, position, debug=false){

    if(icon.display){

      const ldata = this.texData

      // positioning
    
      let 
        posx= (position.x - center.x) * -ldata.scrMapUnitScale,
        posy= (position.y - center.y) * ldata.scrMapUnitScale,
        dist= Math.sqrt(posx * posx + posy * posy);

      if(dist > ldata.iconDistanceMax){
        let distClamp= 1/dist * ldata.iconDistanceMax;
        posx *= distClamp;
        posy *= distClamp;
      }
  
      icon.style.setProperty("--radar-icon-x", -ldata.iconSizeHalf+posx + "px");
      icon.style.setProperty("--radar-icon-y", -ldata.iconSizeHalf+posy + "px");
      
      // animation
      
      let opacity= Math.random() < .66 ? 0.3 + Math.random() * 0.4 : 1.0;
  
      icon.image.setProperty("--radar-icon-a", opacity);
      icon.image_glitch.setProperty("--radar-icon-a", opacity*.5);
      
      if(Math.random() < .2) {
        icon.image.left = (-ldata.iconGlitchOffset + Math.random() * ldata.iconGlitchOffset*2) + "px";
        icon.image.top = (-ldata.iconGlitchOffset + Math.random() * ldata.iconGlitchOffset*2) + "px";
      }
      else{
        icon.image.left = icon.image.top = 0;
      }
  
      if(debug){
        let devfactor= 1/ldata.scrMapUnitScale
        devtext.innerHTML= `x:${-posx*devfactor}<br>y:${posy*devfactor}<br>L:${center.rot}º`
      }
    }
	}

  angleBetween(a, b){
		var lena = Math.sqrt(a.x * a.x + a.y * a.y);
		var lenb = Math.sqrt(b.x * b.x + b.y * b.y);
		var dot = a.x * b.x + a.y * b.y;
		return Math.acos(dot / (lena * lenb));
	}
}