-- Sergio 'Sopze' del Pino @ 2025 -- The Junker Magnusson Device Picker

-- This is NOT coded yet, just a mere copy of trailerFeet.lua

local M = {}
M.type = "auxiliary"

local electricsName = nil
local attachedValue = nil
local detachedValue = nil

local function onCouplerAttached(nodeId, obj2id, obj2nodeId)
  if obj:getId() ~= obj2id then
    electrics.values[electricsName] = attachedValue
  end
end

local function onCouplerDetached(nodeId, obj2id, obj2nodeId, breakForce)
  if obj:getId() ~= obj2id then
    electrics.values[electricsName] = detachedValue
  end
end

local function init(jbeamData)
  electricsName = jbeamData.electricsName or "magdevice_holder"
  attachedValue = jbeamData.attachedValue or 1
  detachedValue = jbeamData.detachedValue or 0

  local startValue = jbeamData.startValue or 0
  electrics.values[electricsName] = startValue
end

M.init = init
M.onCouplerAttached = onCouplerAttached
M.onCouplerDetached = onCouplerDetached

return M
