-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt

local M = {}

local function onReset()
  electrics.values['tilt'] = 0
  electrics.values['tilt_input'] = 0
  electrics.values['recline'] = 0
  electrics.values['recline_input'] = 0
  electrics.values['tilta'] = 0
  electrics.values['tilta_input'] = 0
  electrics.values['reclinea'] = 0
  electrics.values['reclinea_input'] = 0
end

local function updateGFX(dt) -- ms
  electrics.values['tilt'] = math.min(1, math.max(-1.0, (electrics.values['tilt'] + electrics.values['tilt_input'] * dt * 5)))
  electrics.values['recline'] = math.min(1, math.max(-1.0, (electrics.values['recline'] + electrics.values['recline_input'] * dt * 0.5)))
  electrics.values['tilta'] = math.min(1, math.max(-1.0, (electrics.values['tilta'] + electrics.values['tilta_input'] * dt * 5)))
  electrics.values['reclinea'] = math.min(1, math.max(-1.0, (electrics.values['reclinea'] + electrics.values['reclinea_input'] * dt * 0.5)))
end

local function tiltBed(value)
  electrics.values.tilt_input = value
end

local function reclineseat(value)
  electrics.values.recline_input = value
end

local function tiltBeda(value)
  electrics.values.tilta_input = value
end

local function reclineseata(value)
  electrics.values.reclinea_input = value
end

-- public interface
M.onInit    = onReset
M.onReset   = onReset
M.updateGFX = updateGFX
M.tiltBed = tiltBed
M.reclineseat = reclineseat
M.tiltBeda = tiltBeda
M.reclineseata = reclineseata

return M
