local M = {}

local initialDoor = nil
local door = nil
local lockState = nil

local signalTimer = nil
local signalType = nil

local function setLock(doorNum, notDisplay)
    local state
    if doorNum == 0 then
        state = electrics.values.ifLock0
        door = "front left"
    elseif doorNum == 1 then
        state = electrics.values.ifLock1
        door = "front right"
    elseif doorNum == 2 then
        state = electrics.values.ifLock2
        door = "rear left"
    elseif doorNum == 3 then
        state = electrics.values.ifLock3
        door = "rear right"
    elseif doorNum == 4 then
        state = electrics.values.ifLock4
        door = "tailgate"
    end

    if state == 0 then
        if doorNum == 0 then
            electrics.values.ifLock0 = 1
        elseif doorNum == 1 then
            electrics.values.ifLock1 = 1
        elseif doorNum == 2 then
            electrics.values.ifLock2 = 1
        elseif doorNum == 3 then
            electrics.values.ifLock3 = 1
		elseif doorNum == 4 then
            electrics.values.ifLock4 = 1
        end
        if not notDisplay then
            guihooks.message("The " .. door .. " door has been locked." , 1, "")
        end
    elseif state == 1 then
        if doorNum == 0 then
            electrics.values.ifLock0 = 0
        elseif doorNum == 1 then
            electrics.values.ifLock1 = 0
        elseif doorNum == 2 then
            electrics.values.ifLock2 = 0
        elseif doorNum == 3 then
            electrics.values.ifLock3 = 0
		elseif doorNum == 4 then
            electrics.values.ifLock4 = 0
        end
        if not notDisplay then
            guihooks.message("The " .. door .. " door has been unlocked." , 1, "")
        end
    else
        guihooks.message("error" , 1, "")
    end

    -- signalTimer = 1
end

local function allLock(lock)
    electrics.values.ifLock0 = lock
    electrics.values.ifLock1 = lock
    electrics.values.ifLock2 = lock
    electrics.values.ifLock3 = lock
    electrics.values.ifLock4 = lock
end

local function setAllDoors(lock)
    allLock(lock)
    if lock == 1 then
        guihooks.message("All doors have been locked." , 1, "")
    elseif lock == 0 then
        guihooks.message("All doors have been unlocked." , 1, "")
    end
    signalTimer = 1
    signalType = lock
end

local function updateGFX(dt)
    -- auto lock 
    if electrics.values.ifLock0 == 1 and electrics.values.ifLock1 == 1 and electrics.values.ifLock2 == 1 and electrics.values.ifLock3 == 1 and electrics.values.ifLock4 == 1 then
        lockState = 1
    else
        lockState = 0
    end

    -- light signal
    if signalTimer > 0 then
        if signalType == 0 then
            if signalTimer < 0.25 or (signalTimer > 0.5 and signalTimer < 0.75) then
                electrics.values.sigL = 2
                electrics.values.sigR = 2
            else
                electrics.values.sigL = 0
                electrics.values.sigR = 0
            end
        elseif signalType == 1 then
            electrics.values.sigL = 2
            electrics.values.sigR = 2
        end

        signalTimer = math.max(0, signalTimer - dt)
    else
        electrics.values.sigL = electrics.values.signal_L
        electrics.values.sigR = electrics.values.signal_R
    end

    -- log("D", "", )
end

local function setAllDoors2()
    if lockState == 0 then
        setAllDoors(1)
    elseif lockState == 1 then
        setAllDoors(0)
    end
end

local function init(jbeamData)
    lockState = 1
    signalTimer = 0
    signalType  = 0

    electrics.values.ifLock0 = 0
    electrics.values.ifLock1 = 0
    electrics.values.ifLock2 = 0
    electrics.values.ifLock3 = 0
    electrics.values.ifLock4 = 0

end

local function reset()
    electrics.values.ifLock0 = 0
    electrics.values.ifLock1 = 0
    electrics.values.ifLock2 = 0
    electrics.values.ifLock3 = 0
    electrics.values.ifLock4 = 0
end

M.signalTimer = signalTimer

M.setLock = setLock
M.setAllDoors = setAllDoors
M.setAllDoors2 = setAllDoors2

M.init = init
M.reset = reset
M.updateGFX = updateGFX

return M