local M = {}
local device = nil
local timer = 0
local timer2 = 0
local manifoldDanger = 0
local manifoldDanger2 = 0
local timerToofast = 0

local function onInit()

  if electrics.values["isSimpleTrafficCar"] then
	M.updateGFX = nop
	M.onReset = nop
	return
  end
  
    device = powertrain.getDevice("mainEngine")
    electrics.values["manifoldDanger"] = 0
    electrics.values["manifoldDanger2"] = 0
	manifoldDanger = 0
	manifoldDanger2 = 0
	timer = 0
	timer2 = 0
	timerToofast = 0
	electrics.values["checkengineCustom"] = false
  if electrics.values["flightMode"] == nil then electrics.values["flightMode"] = 0 end		--Airplane gauge light logic, also to prevent the laptop from showing the terminal engine damage message while flying

end

local function onReset()
	electrics.values["manifoldDanger"] = 0
    electrics.values["manifoldDanger2"] = 0
	manifoldDanger = 0
	manifoldDanger2 = 0
	timer = 0
	timer2 = 0
	timerToofast = 0
	electrics.values["checkengineCustom"] = false
  if electrics.values["flightMode"] == nil then electrics.values["flightMode"] = 0 end

end

local function updateGFX(dt) 

  if electrics.values["checkengine"] == true and electrics.values["flightMode"] == 0 then
		electrics.values["checkengineCustom"] = true
  else
		electrics.values["checkengineCustom"] = false 
  end
--------

  if electrics.values.airspeed > 100 and electrics.values["flightMode"] == 1 then	--wings get unstable above these speeds
  	timerToofast = timerToofast + dt
  	if timerToofast >= 0.4 then
		if electrics.values["flyingTooFast"] == 0 then
			electrics.values["flyingTooFast"] = 1
		else
			electrics.values["flyingTooFast"] = 0
		end
  		timerToofast = 0
  	end
  else
  	timerToofast = 0
	electrics.values["flyingTooFast"] = 0
  end 

  if device == nil then return end -- prevent lua error when engine removed
	if device.maxTorqueRating == nil then return --prevent lua error from electric engine 
	end
  if device.maxTorqueRating > 0 then
	if device.combustionTorque > device.maxTorqueRating then 
		manifoldDanger = 1
		
		timer = timer + dt	
	end
  if manifoldDanger == 1 and timer <= 0.12 then  --logic for flashing screen
    electrics.values["manifoldDanger"] = 1
  end
  if manifoldDanger == 1 and timer >= 0.12 then
	timer2 = timer2 + dt
    electrics.values["manifoldDanger"] = 0
    electrics.values["manifoldDanger2"] = 1
	
	if timer2 >= 0.12 then						--resets the cycle
    electrics.values["manifoldDanger2"] = 0
	timer = 0
	timer2 = 0
	end
  end
	if device.combustionTorque < device.maxTorqueRating then 
    electrics.values["manifoldDanger"] = 0
    electrics.values["manifoldDanger2"] = 0
	end
  end
end

-- public interface
M.onInit = onInit
M.onReset = onReset
M.updateGFX = updateGFX

return M