local M = {}

local customRevLimiterCutTime = 0.1
local currentStage = 0
local lastTestLimiterState = 0
local lastTestLimiterState2 = 0
local lastLimiterFrarState = 0
local lastInGameLimiterToggle = 0

-- دالة init لتهيئة القيم
local function init()
    currentStage = 0
    lastTestLimiterState = 0
    lastTestLimiterState2 = 0
    lastLimiterFrarState = 0
    lastInGameLimiterToggle = 0
end

local function printCurrentStage()
    print("Current Stage: " .. currentStage)
end

local function updateGFX(dt)
    local testLimiter = electrics.values.Testlimiter or 0
    local testLimiter2 = electrics.values.Testlimiter2 or 0
    local limiterFrar = electrics.values.limiterfrar or 0
    local inGameLimiterToggle = electrics.values.InGameLimiterToggle or 0

    local engine = powertrain.getDevice("mainEngine")
    if engine then
        -- Handle In-Game Limiter Toggle
        if inGameLimiterToggle ~= lastInGameLimiterToggle and inGameLimiterToggle == 1 then
            -- Toggle between Stage 6 and Stage 7
            if currentStage == 6 then
                currentStage = 7
                print("In-Game Limiter: Stage 7 Activated")
                engine.revLimiterAVDrop = customRevLimiterCutTime * 250
                engine.instantAfterFireCoef = customRevLimiterCutTime * 999999999999999999
                engine.revLimiterAV = customRevLimiterCutTime * 5400
            else
                currentStage = 6
                print("In-Game Limiter: Stage 6 Activated")
                engine.revLimiterAVDrop = customRevLimiterCutTime * 250
                engine.instantAfterFireCoef = customRevLimiterCutTime * 0
                engine.revLimiterAV = customRevLimiterCutTime * 5400
            end

            electrics.values.limiterfrar = currentStage
            electrics.values.InGameLimiterToggle = 0 -- reset toggle
        end

        -- Handle Testlimiter Toggle
        if testLimiter ~= lastTestLimiterState then
            currentStage = (currentStage % 5) + 1
            electrics.values.limiterfrar = currentStage
            printCurrentStage()

            if currentStage == 1 then
                engine.revLimiterAVDrop = customRevLimiterCutTime * 1500
                engine.instantAfterFireCoef = customRevLimiterCutTime * 0
                engine.revLimiterAV = customRevLimiterCutTime * 4500
            elseif currentStage == 2 then
                engine.revLimiterAVDrop = customRevLimiterCutTime * 600
                engine.instantAfterFireCoef = customRevLimiterCutTime * 0
                engine.revLimiterAV = customRevLimiterCutTime * 5400
            elseif currentStage == 3 then
                engine.revLimiterAVDrop = customRevLimiterCutTime * 350
                engine.instantAfterFireCoef = customRevLimiterCutTime * 0
                engine.revLimiterAV = customRevLimiterCutTime * 5400
            elseif currentStage == 4 then
                engine.revLimiterAVDrop = customRevLimiterCutTime * 500
                engine.instantAfterFireCoef = customRevLimiterCutTime * 0
                engine.revLimiterAV = customRevLimiterCutTime * 5800
            elseif currentStage == 5 then
                engine.revLimiterAVDrop = customRevLimiterCutTime * 200
                engine.instantAfterFireCoef = customRevLimiterCutTime * 0
                engine.revLimiterAV = customRevLimiterCutTime * 6000
            end
        end

        -- Handle Testlimiter2 Toggle
        if testLimiter2 ~= lastTestLimiterState2 then
            currentStage = (currentStage - 2) % 5 + 1
            electrics.values.limiterfrar = currentStage
            printCurrentStage()

            if currentStage == 1 then
                engine.revLimiterAVDrop = customRevLimiterCutTime * 1700
                engine.instantAfterFireCoef = customRevLimiterCutTime * 0
                engine.revLimiterAV = customRevLimiterCutTime * 5200
            elseif currentStage == 2 then
                engine.revLimiterAVDrop = customRevLimiterCutTime * 600
                engine.instantAfterFireCoef = customRevLimiterCutTime * 0
                engine.revLimiterAV = customRevLimiterCutTime * 5800
            elseif currentStage == 3 then
                engine.revLimiterAVDrop = customRevLimiterCutTime * 350
                engine.instantAfterFireCoef = customRevLimiterCutTime * 0
                engine.revLimiterAV = customRevLimiterCutTime * 5800
            elseif currentStage == 4 then
                engine.revLimiterAVDrop = customRevLimiterCutTime * 400
                engine.instantAfterFireCoef = customRevLimiterCutTime * 0
                engine.revLimiterAV = customRevLimiterCutTime * 6000
            elseif currentStage == 5 then
                engine.revLimiterAVDrop = customRevLimiterCutTime * 1000
                engine.instantAfterFireCoef = customRevLimiterCutTime * 0
                engine.revLimiterAV = customRevLimiterCutTime * 6000
            end
        end

        -- Handle limiterFrar (stage reset)
        if limiterFrar ~= lastLimiterFrarState then
            currentStage = math.floor(limiterFrar)
            electrics.values.limiterfrar = currentStage
        end

        -- Update last state values for toggles
        lastTestLimiterState = testLimiter
        lastTestLimiterState2 = testLimiter2
        lastLimiterFrarState = limiterFrar
        lastInGameLimiterToggle = inGameLimiterToggle
    end
end

M.init = init
M.updateGFX = updateGFX

return M
