angular.module('TundraGPSScreen', [])
    .controller('TundraGPSScreenController', function ($scope, $element, $window) {
        const root = document.getElementById('gpsScreen');
        const mapContainer = document.getElementById('mapContainer');
        const splashScreen = document.getElementById('splashScreen');

        let settings = {}

        // splash: 0 = off, 1 = splash, 2 = on
        let state = { splash: 0, timeout: undefined }

        $window.setup = (data) => {
            beamng.sendActiveObjectLua('fortuner_screens.initMap()');
        }

        $window.updateData = (data) => {
            if (!data) return;

            // Engine/screen state
            if (data.electrics.engineRunning === 0 && state.splash !== 0 && !state.timeout) {
                if (state.timeout) {
                    clearTimeout(state.timeout);
                    state.timeout = undefined;
                }

                root.style.transition = '0.25s ease-out';
                
                // Turn Off
                root.classList.add('engineOff');
                state.splash = 0;

                state.timeout = setTimeout(() => {
                    root.style.backgroundColor = 'black';
                    mapContainer.style.backgroundColor = 'black';
                    splashScreen.style.opacity = 1;
                    root.style.transition = '0.2s ease-out';
                    mapContainer.style.backgroundColor = '#9EA7C3';
                    state.timeout = undefined;
                }, 0.25 * 1000);
            } else if (data.electrics.engineRunning === 1 && state.splash === 0 && !state.timeout) {
                // Turn on to splash screen
                state.timeout = setTimeout(() => {
                    root.classList.remove('engineOff');
                    state.splash = 1;

                    // Hide splash screen
                    state.timeout = setTimeout(() => {
                        root.style.backgroundColor = '#9EA7C3';

                        state.timeout = setTimeout(() => {
                            splashScreen.style.opacity = 0;
                            state.splash = 2;
                            state.timeout = undefined;
                        }, 1 * 1000);
                    }, 3 * 1000);
                }, 0.5 * 1000);
            }

            // Update map
            beamng.sendActiveObjectLua('fortuner_screens.updateMap()');

            // Time
            document.getElementById('time').innerText = new Date().toLocaleString('en-US', {
                hour12: false,
                year: 'numeric',
                month: '2-digit',
                day: '2-digit',
                hour: '2-digit',
                minute: '2-digit',
                second: '2-digit',
            }).split(', ')[1].substring(0, 5);
        }
    });
